/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class LtJoinNoKeyRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final LtJoinNoKeyJoinRecordCursor cursor;

    public LtJoinNoKeyRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.cursor = new LtJoinNoKeyJoinRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
    }

    @Override
    public void close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.masterFactory.getCursor(executionContext), this.slaveFactory.getCursor(executionContext));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private static class LtJoinNoKeyJoinRecordCursor
    implements NoRandomAccessRecordCursor {
        private final OuterJoinRecord record;
        private final int columnSplit;
        private final int masterTimestampIndex;
        private final int slaveTimestampIndex;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private Record slaveRecB;
        private Record slaveRecA;
        private long slaveTimestamp = Long.MIN_VALUE;
        private long latestSlaveRowID = Long.MIN_VALUE;

        public LtJoinNoKeyJoinRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.columnSplit = columnSplit;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                this.nextSlave(masterTimestamp);
                return true;
            }
            return false;
        }

        private void nextSlave(long masterTimestamp) {
            long slaveTimestamp = this.slaveTimestamp;
            this.positionSlaveRecB();
            if (slaveTimestamp < masterTimestamp) {
                this.overScrollSlave(masterTimestamp, slaveTimestamp);
            }
        }

        private void positionSlaveRecB() {
            if (this.latestSlaveRowID != Long.MIN_VALUE) {
                this.record.hasSlave(true);
                this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
            }
        }

        private void slaveIsDone() {
            this.positionSlaveRecB();
            this.slaveTimestamp = Long.MAX_VALUE;
        }

        private void overScrollSlave(long masterTimestamp, long slaveTimestamp) {
            block2: {
                this.latestSlaveRowID = this.slaveRecA.getRowId();
                this.slaveTimestamp = slaveTimestamp;
                while (this.slaveCursor.hasNext()) {
                    slaveTimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
                    if (slaveTimestamp < masterTimestamp) {
                        this.record.hasSlave(true);
                        this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                        this.latestSlaveRowID = this.slaveRecA.getRowId();
                        this.slaveTimestamp = slaveTimestamp;
                        continue;
                    }
                    this.latestSlaveRowID = this.slaveRecA.getRowId();
                    this.slaveTimestamp = slaveTimestamp;
                    break block2;
                }
                this.record.hasSlave(true);
                this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                this.slaveTimestamp = Long.MAX_VALUE;
            }
        }

        @Override
        public void toTop() {
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.record.hasSlave(false);
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecA = slaveCursor.getRecord();
            this.slaveRecB = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecB);
            this.record.hasSlave(false);
        }
    }
}

