/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

public class LtJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final Map joinKeyMap;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final LtJoinRecordCursor cursor;
    private final IntList columnIndex;

    public LtJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.joinKeyMap = MapFactory.createMap(configuration, mapKeyTypes, mapValueTypes);
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new LtJoinRecordCursor(columnSplit, this.joinKeyMap, NullRecordFactory.getInstance(slaveColumnTypes), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), slaveValueSink);
        this.columnIndex = columnIndex;
    }

    @Override
    public void close() {
        this.joinKeyMap.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.masterFactory.getCursor(executionContext), this.slaveFactory.getCursor(executionContext));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private class LtJoinRecordCursor
    implements NoRandomAccessRecordCursor {
        private final OuterJoinRecord record;
        private final Map joinKeyMap;
        private final int columnSplit;
        private final int masterTimestampIndex;
        private final int slaveTimestampIndex;
        private final RecordValueSink valueSink;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private Record slaveRecord;
        private long slaveTimestamp = Long.MIN_VALUE;
        private boolean danglingSlaveRecord = false;

        public LtJoinRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, RecordValueSink valueSink) {
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.columnSplit = columnSplit;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.valueSink = valueSink;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                MapValue value;
                MapKey key;
                long slaveTimestamp = this.slaveTimestamp;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (slaveTimestamp < masterTimestamp) {
                    if (this.danglingSlaveRecord) {
                        key = this.joinKeyMap.withKey();
                        key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        this.valueSink.copy(this.slaveRecord, value);
                        this.danglingSlaveRecord = false;
                    }
                    while (this.slaveCursor.hasNext()) {
                        slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                        if (slaveTimestamp < masterTimestamp) {
                            key = this.joinKeyMap.withKey();
                            key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            this.valueSink.copy(this.slaveRecord, value);
                            continue;
                        }
                        this.danglingSlaveRecord = true;
                        break;
                    }
                    this.slaveTimestamp = slaveTimestamp;
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, LtJoinRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    value.setMapRecordHere();
                    this.record.hasSlave(true);
                } else {
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecord();
            MapRecord mapRecord = this.joinKeyMap.getRecord();
            mapRecord.setSymbolTableResolver(slaveCursor, LtJoinRecordCursorFactory.this.columnIndex);
            this.record.of(this.masterRecord, mapRecord);
        }
    }
}

