/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Chars;
import io.questdb.std.Misc;

public class RecordAsAFieldRecordCursorFactory
implements RecordCursorFactory {
    private final RecordCursorFactory base;
    private final GenericRecordMetadata metadata;
    private final RecordAsAFieldRecordCursor cursor;

    public RecordAsAFieldRecordCursorFactory(RecordCursorFactory base, CharSequence columnAlias) {
        this.base = base;
        this.cursor = new RecordAsAFieldRecordCursor();
        this.metadata = new GenericRecordMetadata();
        this.metadata.add(new TableColumnMetadata(Chars.toString(columnAlias), 17, base.getMetadata()));
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.base.getCursor(executionContext), executionContext);
        return this.cursor;
    }

    @Override
    public void close() {
        Misc.free(this.base);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    private static final class RecordAsAFieldRecordCursor
    implements DelegatingRecordCursor {
        private final RecordAsAFieldRecord record = new RecordAsAFieldRecord();
        private final RecordAsAFieldRecord recordB = new RecordAsAFieldRecord();
        private RecordCursor base;

        private RecordAsAFieldRecordCursor() {
        }

        @Override
        public void close() {
            Misc.free(this.base);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(((RecordAsAFieldRecord)record).base, atRowId);
        }

        @Override
        public void toTop() {
            this.base.toTop();
        }

        @Override
        public long size() {
            return this.base.size();
        }

        @Override
        public void of(RecordCursor base, SqlExecutionContext executionContext) {
            this.base = base;
            this.record.base = base.getRecord();
        }
    }

    private static final class RecordAsAFieldRecord
    implements Record {
        private Record base;

        private RecordAsAFieldRecord() {
        }

        @Override
        public Record getRecord(int col) {
            assert (col == 0);
            return this.base;
        }
    }
}

