/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.std.Misc;

public class SpliceJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int VAL_MASTER_PREV = 0;
    private static final int VAL_MASTER_NEXT = 1;
    private static final int VAL_SLAVE_PREV = 2;
    private static final int VAL_SLAVE_NEXT = 3;
    private static final long NULL_ROWID = -1L;
    private final RecordCursorFactory slaveFactory;
    private final RecordCursorFactory masterFactory;
    private final Map joinKeyMap;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final SpliceJoinLightRecordCursor cursor;

    public SpliceJoinLightRecordCursorFactory(CairoConfiguration cairoConfiguration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveSink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.joinKeyMap = MapFactory.createMap(cairoConfiguration, joinColumnTypes, valueTypes);
        this.masterKeySink = masterSink;
        this.slaveKeySink = slaveSink;
        this.cursor = new SpliceJoinLightRecordCursor(this.joinKeyMap, columnSplit, masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), NullRecordFactory.getInstance(masterFactory.getMetadata()), NullRecordFactory.getInstance(slaveFactory.getMetadata()));
    }

    @Override
    public void close() {
        this.joinKeyMap.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.masterFactory.getCursor(executionContext), this.slaveFactory.getCursor(executionContext));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private class SpliceJoinLightRecordCursor
    implements NoRandomAccessRecordCursor {
        private final JoinRecord record;
        private final Map joinKeyMap;
        private final int columnSplit;
        private final int masterTimestampIndex;
        private final int slaveTimestampIndex;
        private final Record nullMasterRecord;
        private final Record nullSlaveRecord;
        private Record masterRecord2;
        private Record slaveRecord2;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private Record slaveRecord;
        private long masterKeyAddress = -1L;
        private long slaveKeyAddress = -1L;
        private long masterTimestamp = -1L;
        private long slaveTimestamp = -1L;
        private boolean fetchMaster = true;
        private boolean fetchSlave = true;
        private boolean hasMaster = true;
        private boolean hasSlave = true;
        private boolean dualRecord = false;

        public SpliceJoinLightRecordCursor(Map joinKeyMap, int columnSplit, int masterTimestampIndex, int slaveTimestampIndex, Record nullMasterRecord, Record nullSlaveRecord) {
            this.record = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.columnSplit = columnSplit;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.nullMasterRecord = nullMasterRecord;
            this.nullSlaveRecord = nullSlaveRecord;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public boolean hasNext() {
            MapValue value;
            MapKey key;
            if (this.dualRecord) {
                this.slaveRecordLeads();
                this.dualRecord = false;
            }
            if (this.fetchMaster && this.hasMaster && this.masterCursor.hasNext()) {
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, SpliceJoinLightRecordCursorFactory.this.masterKeySink);
                value = key.createValue();
                this.masterKeyAddress = value.getAddress();
                if (value.isNew()) {
                    value.putLong(0, -1L);
                    value.putLong(2, -1L);
                    value.putLong(3, -1L);
                } else {
                    value.putLong(0, value.getLong(1));
                }
                value.putLong(1, this.masterRecord.getRowId());
                this.masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
            } else if (this.fetchMaster && this.hasMaster) {
                this.hasMaster = false;
                this.masterTimestamp = Long.MAX_VALUE;
            }
            if (this.fetchSlave && this.hasSlave && this.slaveCursor.hasNext()) {
                key = this.joinKeyMap.withKey();
                key.put(this.slaveRecord, SpliceJoinLightRecordCursorFactory.this.slaveKeySink);
                value = key.createValue();
                this.slaveKeyAddress = value.getAddress();
                if (value.isNew()) {
                    value.putLong(0, -1L);
                    value.putLong(1, -1L);
                    value.putLong(2, -1L);
                } else {
                    value.putLong(2, value.getLong(3));
                }
                value.putLong(3, this.slaveRecord.getRowId());
                this.slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
            } else if (this.fetchSlave && this.hasSlave) {
                this.hasSlave = false;
                this.slaveTimestamp = Long.MAX_VALUE;
            }
            if (this.masterTimestamp < this.slaveTimestamp) {
                this.masterRecordLeads();
                this.fetchMaster = true;
                this.fetchSlave = false;
            } else if (this.masterTimestamp > this.slaveTimestamp) {
                this.slaveRecordLeads();
                this.fetchMaster = false;
                this.fetchSlave = true;
            } else {
                if (this.slaveTimestamp == Long.MAX_VALUE) {
                    return false;
                }
                if (this.masterKeyAddress == this.slaveKeyAddress) {
                    this.record.of(this.masterRecord, this.slaveRecord);
                } else {
                    this.masterRecordLeads();
                    this.dualRecord = true;
                }
                this.fetchMaster = true;
                this.fetchSlave = true;
            }
            return true;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.resetState();
        }

        @Override
        public long size() {
            return -1L;
        }

        private void masterRecordLeads() {
            long rowid = this.joinKeyMap.valueAt(this.masterKeyAddress).getLong(this.hasSlave ? 2 : 3);
            if (rowid == -1L) {
                this.record.of(this.masterRecord, this.nullSlaveRecord);
            } else {
                this.slaveCursor.recordAt(this.slaveRecord2, rowid);
                this.record.of(this.masterRecord, this.slaveRecord2);
            }
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (this.masterCursor == null) {
                this.masterCursor = masterCursor;
                this.slaveCursor = slaveCursor;
                this.masterRecord = masterCursor.getRecord();
                this.slaveRecord = slaveCursor.getRecord();
                this.masterRecord2 = masterCursor.getRecordB();
                this.slaveRecord2 = slaveCursor.getRecordB();
            }
            this.resetState();
        }

        private void resetState() {
            this.joinKeyMap.clear();
            this.masterKeyAddress = -1L;
            this.slaveKeyAddress = -1L;
            this.masterTimestamp = -1L;
            this.slaveTimestamp = -1L;
            this.fetchMaster = true;
            this.fetchSlave = true;
            this.hasMaster = true;
            this.hasSlave = true;
            this.dualRecord = false;
        }

        private void slaveRecordLeads() {
            long rowid = this.joinKeyMap.valueAt(this.slaveKeyAddress).getLong(this.hasMaster ? 0 : 1);
            if (rowid == -1L) {
                this.record.of(this.nullMasterRecord, this.slaveRecord);
            } else {
                this.masterCursor.recordAt(this.masterRecord2, rowid);
                this.record.of(this.masterRecord2, this.slaveRecord);
            }
        }
    }
}

