/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;

public class SortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LongTreeChain chain;
    private final SortedLightRecordCursor cursor;

    public SortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator) {
        super(metadata);
        this.chain = new LongTreeChain(configuration.getSqlSortKeyPageSize(), configuration.getSqlSortKeyMaxPages(), configuration.getSqlSortLightValuePageSize(), configuration.getSqlSortLightValueMaxPages());
        this.base = base;
        this.cursor = new SortedLightRecordCursor(this.chain, comparator);
    }

    @Override
    public void close() {
        this.base.close();
        this.chain.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (RuntimeException ex) {
            baseCursor.close();
            throw ex;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }
}

