/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.griffin.engine.orderby.RecordTreeChain;

class SortedRecordCursor
implements DelegatingRecordCursor {
    private final RecordTreeChain chain;
    private RecordTreeChain.TreeCursor chainCursor;

    public SortedRecordCursor(RecordTreeChain chain) {
        this.chain = chain;
    }

    @Override
    public void close() {
        this.chainCursor.close();
        this.chain.clear();
    }

    @Override
    public Record getRecord() {
        return this.chainCursor.getRecord();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.chainCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        return this.chainCursor.hasNext();
    }

    @Override
    public Record getRecordB() {
        return this.chainCursor.getRecordB();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.chainCursor.recordAt(record, atRowId);
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
    }

    @Override
    public long size() {
        return this.chainCursor.size();
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) {
        try {
            this.chainCursor = this.chain.getCursor(base);
            Record record = base.getRecord();
            SqlExecutionInterruptor interruptor = executionContext.getSqlExecutionInterruptor();
            this.chain.clear();
            while (base.hasNext()) {
                interruptor.checkInterrupted();
                this.chain.put(record);
            }
            this.chainCursor.toTop();
        }
        catch (Throwable ex) {
            base.close();
            throw ex;
        }
    }
}

