/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeferredTreeSetRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    protected final IntHashSet symbolKeys;
    private final int columnIndex;
    private final CharSequenceHashSet deferredSymbols;

    public AbstractDeferredTreeSetRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, CharSequenceHashSet keyValues, SymbolMapReader symbolMapReader) {
        super(metadata, dataFrameCursorFactory, configuration);
        int nKeyValues = keyValues.size();
        IntHashSet symbolKeys = new IntHashSet(nKeyValues);
        CharSequenceHashSet deferredSymbols = null;
        for (int i = 0; i < nKeyValues; ++i) {
            CharSequence symbol = keyValues.get(i);
            int symbolKey = symbolMapReader.keyOf(symbol);
            if (symbolKey == -2) {
                if (deferredSymbols == null) {
                    deferredSymbols = new CharSequenceHashSet();
                }
                deferredSymbols.add(Chars.toString(symbol));
                continue;
            }
            symbolKeys.add(TableUtils.toIndexKey(symbolKey));
        }
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbols = deferredSymbols;
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        if (this.deferredSymbols != null && this.deferredSymbols.size() > 0) {
            SymbolMapReader symbolTable = dataFrameCursor.getSymbolTable(this.columnIndex);
            int i = 0;
            int n = this.deferredSymbols.size();
            while (i < n) {
                CharSequence symbol = this.deferredSymbols.get(i);
                int symbolKey = symbolTable.keyOf(symbol);
                if (symbolKey != -2) {
                    this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
                    this.deferredSymbols.remove(symbol);
                    --n;
                    continue;
                }
                ++i;
            }
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }
}

