/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRandomRecordCursor;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDeferredValueRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    protected final Function filter;
    protected final int columnIndex;
    private final String symbol;
    private AbstractDataFrameRecordCursor cursor;

    public AbstractDeferredValueRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, String symbol, @Nullable Function filter) {
        super(metadata, dataFrameCursorFactory);
        this.columnIndex = columnIndex;
        this.symbol = symbol;
        this.filter = filter;
    }

    @Override
    public void close() {
        super.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    protected abstract AbstractDataFrameRecordCursor createDataFrameCursorFor(int var1);

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        if (this.cursor == null && this.lookupDeferredSymbol(dataFrameCursor)) {
            if (this.recordCursorSupportsRandomAccess()) {
                return EmptyTableRandomRecordCursor.INSTANCE;
            }
            return EmptyTableRecordCursor.INSTANCE;
        }
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }

    private boolean lookupDeferredSymbol(DataFrameCursor dataFrameCursor) {
        int symbolKey = dataFrameCursor.getSymbolTable(this.columnIndex).keyOf(this.symbol);
        if (symbolKey == -2) {
            dataFrameCursor.close();
            return true;
        }
        this.cursor = this.createDataFrameCursorFor(symbolKey);
        return false;
    }
}

