/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.NoMoreFramesException;
import io.questdb.std.IntList;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataFrameRecordCursor
extends AbstractDataFrameRecordCursor {
    private final RowCursorFactory rowCursorFactory;
    private final boolean entityCursor;
    private RowCursor rowCursor;
    private BooleanSupplier next;
    private final BooleanSupplier nextRow = this::nextRow;
    private final BooleanSupplier nextFrame = this::nextFrame;
    private final Function filter;

    public DataFrameRecordCursor(RowCursorFactory rowCursorFactory, boolean entityCursor, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(columnIndexes);
        this.rowCursorFactory = rowCursorFactory;
        this.entityCursor = entityCursor;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next.getAsBoolean();
        }
        catch (NoMoreFramesException ignore) {
            return false;
        }
    }

    @Override
    public void toTop() {
        if (this.filter != null) {
            this.filter.toTop();
        }
        this.dataFrameCursor.toTop();
        this.next = this.nextFrame;
    }

    private boolean nextRow() {
        if (this.rowCursor.hasNext()) {
            this.recordA.setRecordIndex(this.rowCursor.next());
            return true;
        }
        return this.nextFrame();
    }

    @Override
    public void of(DataFrameCursor dataFrameCursor, SqlExecutionContext sqlExecutionContext) {
        if (this.dataFrameCursor != dataFrameCursor) {
            this.close();
            this.dataFrameCursor = dataFrameCursor;
        }
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.rowCursorFactory.prepareCursor(dataFrameCursor.getTableReader(), sqlExecutionContext);
        this.next = this.nextFrame;
    }

    @Override
    public long size() {
        return this.entityCursor ? this.dataFrameCursor.size() : -1L;
    }

    private boolean nextFrame() {
        DataFrame dataFrame;
        while ((dataFrame = this.dataFrameCursor.next()) != null) {
            this.rowCursor = this.rowCursorFactory.getCursor(dataFrame);
            if (!this.rowCursor.hasNext()) continue;
            this.recordA.jumpTo(dataFrame.getPartitionIndex(), this.rowCursor.next());
            this.next = this.nextRow;
            return true;
        }
        return false;
    }
}

