/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.NullColumn;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFrameRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final boolean followsOrderByAdvice;
    private final Function filter;
    private final boolean framingSupported;
    private final IntList columnIndexes;
    private final IntList columnSizes;
    private TableReaderPageFrameCursor pageFrameCursor;

    public DataFrameRecordCursorFactory(RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, RowCursorFactory rowCursorFactory, boolean followsOrderByAdvice, @Nullable Function filter, boolean framingSupported, @NotNull IntList columnIndexes, @Nullable IntList columnSizes) {
        super(metadata, dataFrameCursorFactory);
        this.cursor = new DataFrameRecordCursor(rowCursorFactory, rowCursorFactory.isEntity(), filter, columnIndexes);
        this.followsOrderByAdvice = followsOrderByAdvice;
        this.filter = filter;
        this.framingSupported = framingSupported;
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
    }

    @Override
    public void close() {
        Misc.free(this.filter);
        Misc.free(this.dataFrameCursorFactory);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followsOrderByAdvice;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext) {
        DataFrameCursor dataFrameCursor = this.dataFrameCursorFactory.getCursor(executionContext);
        if (this.pageFrameCursor != null) {
            return this.pageFrameCursor.of(dataFrameCursor);
        }
        if (this.framingSupported) {
            this.pageFrameCursor = new TableReaderPageFrameCursor(this.columnIndexes, this.columnSizes, this.getMetadata().getTimestampIndex());
            return this.pageFrameCursor.of(dataFrameCursor);
        }
        return null;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.framingSupported;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("{\"name\":\"DataFrameRecordCursorFactory\", \"cursorFactory\":");
        this.dataFrameCursorFactory.toSink(sink);
        sink.put('}');
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }

    private static class TableReaderPageFrameCursor
    implements PageFrameCursor {
        private final LongList columnPageNextAddress = new LongList();
        private final LongList columnPageAddress = new LongList();
        private final TableReaderPageFrame frame = new TableReaderPageFrame();
        private final LongList topsRemaining = new LongList();
        private final IntList pages = new IntList();
        private final int columnCount;
        private final IntList columnIndexes;
        private final IntList columnSizes;
        private final LongList pageNRowsRemaining = new LongList();
        private final LongList pageSizes = new LongList();
        private TableReader reader;
        private int partitionIndex;
        private long partitionRemaining = 0L;
        private DataFrameCursor dataFrameCursor;
        private final int timestampIndex;

        public TableReaderPageFrameCursor(IntList columnIndexes, IntList columnSizes, int timestampIndex) {
            this.columnIndexes = columnIndexes;
            this.columnSizes = columnSizes;
            this.columnCount = columnIndexes.size();
            this.timestampIndex = timestampIndex;
        }

        @Override
        public void close() {
            this.dataFrameCursor = Misc.free(this.dataFrameCursor);
        }

        @Override
        @Nullable
        public PageFrame next() {
            DataFrame dataFrame;
            long m;
            if (this.partitionIndex > -1 && (m = this.computePageMin(this.reader.getColumnBase(this.partitionIndex))) < Long.MAX_VALUE) {
                return this.computeFrame(m);
            }
            while ((dataFrame = this.dataFrameCursor.next()) != null) {
                int i;
                this.partitionIndex = dataFrame.getPartitionIndex();
                long partitionLo = dataFrame.getRowLo();
                long partitionHi = dataFrame.getRowHi();
                this.partitionRemaining = partitionHi - partitionLo;
                if (this.partitionRemaining <= 0L) continue;
                int base = this.reader.getColumnBase(dataFrame.getPartitionIndex());
                for (i = 0; i < this.columnCount; ++i) {
                    int columnIndex = this.columnIndexes.getQuick(i);
                    this.topsRemaining.setQuick(i, this.reader.getColumnTop(base, columnIndex));
                    this.pages.setQuick(i, 0);
                    this.pageNRowsRemaining.setQuick(i, -1L);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    long loRemaining = partitionLo;
                    long top = this.topsRemaining.getQuick(i);
                    if (top >= partitionLo) {
                        loRemaining = 0L;
                        this.topsRemaining.setQuick(i, Math.min(top -= partitionLo, partitionHi - partitionLo));
                    } else {
                        this.topsRemaining.setQuick(i, 0L);
                        loRemaining -= top;
                    }
                    if (loRemaining <= 0L) continue;
                    ReadOnlyVirtualMemory col = this.reader.getColumn(TableReader.getPrimaryColumnIndex(base, this.columnIndexes.getQuick(i)));
                    if (col instanceof NullColumn) {
                        this.columnPageNextAddress.setQuick(i, 0L);
                        this.pageNRowsRemaining.setQuick(i, 0L);
                        continue;
                    }
                    int page = this.pages.getQuick(i);
                    long pageSize = col.getPageSize(page) >> this.columnSizes.getQuick(i);
                    if (pageSize < loRemaining) {
                        throw CairoException.instance(0).put("partition is not mapped as single page, cannot perform vector calculation");
                    }
                    long addr = col.getPageAddress(page);
                    this.columnPageNextAddress.setQuick(i, addr += loRemaining << this.columnSizes.getQuick(i));
                    long pageHi = Math.min(partitionHi, pageSize);
                    this.pageNRowsRemaining.setQuick(i, pageHi - partitionLo);
                    this.pages.setQuick(i, page);
                }
                return this.computeFrame(this.computePageMin(base));
            }
            return null;
        }

        @Override
        public void toTop() {
            this.partitionIndex = -1;
            this.dataFrameCursor.toTop();
            this.pages.setAll(this.columnCount, 0);
            this.topsRemaining.setAll(this.columnCount, 0L);
            this.columnPageAddress.setAll(this.columnCount, 0L);
            this.columnPageNextAddress.setAll(this.columnCount, 0L);
            this.pageNRowsRemaining.setAll(this.columnCount, -1L);
            this.pageSizes.setAll(this.columnCount, -1L);
        }

        @Override
        public long size() {
            return this.reader.size();
        }

        @Override
        public SymbolMapReader getSymbolMapReader(int columnIndex) {
            return this.reader.getSymbolMapReader(this.columnIndexes.getQuick(columnIndex));
        }

        public TableReaderPageFrameCursor of(DataFrameCursor dataFrameCursor) {
            this.reader = dataFrameCursor.getTableReader();
            this.dataFrameCursor = dataFrameCursor;
            this.toTop();
            return this;
        }

        private PageFrame computeFrame(long min) {
            for (int i = 0; i < this.columnCount; ++i) {
                long top = this.topsRemaining.getQuick(i);
                if (top > 0L) {
                    assert (min <= top);
                    this.topsRemaining.setQuick(i, top - min);
                    this.columnPageAddress.setQuick(i, 0L);
                    this.pageSizes.setQuick(i, min);
                    continue;
                }
                long addr = this.columnPageNextAddress.getQuick(i);
                long psz = this.pageNRowsRemaining.getQuick(i);
                this.pageNRowsRemaining.setQuick(i, psz - min);
                this.columnPageAddress.setQuick(i, addr);
                if (addr != 0L) {
                    long pageSize = min << this.columnSizes.getQuick(i);
                    this.pageSizes.setQuick(i, pageSize);
                    this.columnPageNextAddress.setQuick(i, addr + pageSize);
                    continue;
                }
                this.pageSizes.setQuick(i, min);
            }
            this.partitionRemaining -= min;
            if (this.partitionRemaining < 0L) {
                throw CairoException.instance(0).put("incorrect frame built for vector calculation");
            }
            return this.frame;
        }

        private long computePageMin(int base) {
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.columnCount; ++i) {
                long top = this.topsRemaining.getQuick(i);
                if (top > 0L) {
                    if (min <= top) continue;
                    min = top;
                    continue;
                }
                long psz = this.pageNRowsRemaining.getQuick(i);
                if (psz > 0L) {
                    if (min <= psz) continue;
                    min = psz;
                    continue;
                }
                if (this.partitionRemaining <= 0L) continue;
                int page = this.pages.getQuick(i);
                this.pages.setQuick(i, page + 1);
                ReadOnlyVirtualMemory col = this.reader.getColumn(TableReader.getPrimaryColumnIndex(base, this.columnIndexes.getQuick(i)));
                this.columnPageNextAddress.setQuick(i, col.getPageAddress(page));
                psz = !(col instanceof NullColumn) ? col.getPageSize(page) >> this.columnSizes.getQuick(i) : this.partitionRemaining;
                long m = Math.min(psz, this.partitionRemaining);
                this.pageNRowsRemaining.setQuick(i, m);
                if (min <= m) continue;
                min = m;
            }
            return min;
        }

        private class TableReaderPageFrame
        implements PageFrame {
            private TableReaderPageFrame() {
            }

            @Override
            public long getFirstTimestamp() {
                if (TableReaderPageFrameCursor.this.timestampIndex != -1) {
                    return Unsafe.getUnsafe().getLong(TableReaderPageFrameCursor.this.columnPageAddress.getQuick(TableReaderPageFrameCursor.this.timestampIndex));
                }
                return Long.MIN_VALUE;
            }

            @Override
            public long getPageAddress(int columnIndex) {
                return TableReaderPageFrameCursor.this.columnPageAddress.getQuick(columnIndex);
            }

            @Override
            public long getPageSize(int columnIndex) {
                return TableReaderPageFrameCursor.this.pageSizes.getQuick(columnIndex);
            }
        }
    }
}

