/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnExcludedValuesRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final int columnIndex;
    private final Function filter;
    private final ObjList<RowCursorFactory> cursorFactories;
    private final ObjList<Function> keyExcludedValueFunctions = new ObjList();
    private final ObjList<CharSequence> includedValues = new ObjList();
    private final ObjList<CharSequence> excludedValues = new ObjList();
    private final boolean followedOrderByAdvice;
    private final int indexDirection;
    private final int maxSymbolNotEqualsCount;
    private final IntList columnIndexes;

    public FilterOnExcludedValuesRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull ObjList<Function> keyValues, int columnIndex, @Nullable Function filter, int orderByMnemonic, boolean followedOrderByAdvice, int indexDirection, @NotNull IntList columnIndexes, int maxSymbolNotEqualsCount) {
        super(metadata, dataFrameCursorFactory);
        this.indexDirection = indexDirection;
        this.maxSymbolNotEqualsCount = maxSymbolNotEqualsCount;
        int nKeyValues = keyValues.size();
        this.keyExcludedValueFunctions.addAll(keyValues);
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cursorFactories = new ObjList(nKeyValues);
        this.cursor = orderByMnemonic == 2 ? new DataFrameRecordCursor(new SequentialRowCursorFactory(this.cursorFactories), false, filter, columnIndexes) : new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories), false, filter, columnIndexes);
        this.followedOrderByAdvice = followedOrderByAdvice;
        this.columnIndexes = columnIndexes;
    }

    @Override
    public void close() {
        Misc.free(this.filter);
        Misc.free(this.includedValues);
        Misc.free(this.keyExcludedValueFunctions);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    public void recalculateIncludedValues(TableReader tableReader) {
        this.excludedValues.clear();
        int n = this.keyExcludedValueFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.excludedValues.add(Chars.toString(this.keyExcludedValueFunctions.getQuick(i).getStr(null)));
        }
        SymbolMapReaderImpl symbolMapReader = (SymbolMapReaderImpl)tableReader.getSymbolMapReader(this.columnIndex);
        for (int i = 0; i < symbolMapReader.size(); ++i) {
            CharSequence symbol = symbolMapReader.valueOf(i);
            if (this.excludedValues.indexOf(symbol) >= 0 || this.includedValues.indexOf(symbol) >= 0) continue;
            int symbolKey = symbolMapReader.keyOf(symbol);
            FunctionBasedRowCursorFactory rowCursorFactory = this.filter == null ? new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, this.cursorFactories.size() == 0, this.indexDirection, null) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, this.cursorFactories.size() == 0, this.indexDirection, this.columnIndexes, null);
            this.includedValues.add(Chars.toString(symbol));
            this.cursorFactories.add(rowCursorFactory);
        }
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        try (TableReader reader = dataFrameCursor.getTableReader();){
            if (reader.getSymbolMapReader(this.columnIndex).size() > this.maxSymbolNotEqualsCount) {
                throw ReaderOutOfDateException.INSTANCE;
            }
            Function.init(this.keyExcludedValueFunctions, reader, executionContext);
        }
        this.recalculateIncludedValues(dataFrameCursor.getTableReader());
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

