/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class LatestByAllIndexedFilteredRecordCursor
extends AbstractRecordListCursor {
    private final int columnIndex;
    private final IntHashSet found = new IntHashSet();
    private final Function filter;

    public LatestByAllIndexedFilteredRecordCursor(int columnIndex, @NotNull DirectLongList rows, @NotNull Function filter, @NotNull IntList columnIndexes) {
        super(rows, columnIndexes);
        this.columnIndex = columnIndex;
        this.filter = filter;
    }

    @Override
    public void close() {
        this.filter.close();
        super.close();
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        DataFrame frame;
        this.found.clear();
        this.filter.init(this, executionContext);
        int keyCount = this.dataFrameCursor.getTableReader().getSymbolMapReader(this.columnIndex).size() + 1;
        int keyLo = 0;
        int keyHi = keyCount;
        int localLo = Integer.MAX_VALUE;
        int localHi = Integer.MIN_VALUE;
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < keyCount) {
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            int partitionIndex = frame.getPartitionIndex();
            this.recordA.jumpTo(partitionIndex, 0L);
            for (int i = keyLo; i < keyHi; ++i) {
                int index = this.found.keyIndex(i);
                if (index <= -1) continue;
                RowCursor cursor = indexReader.getCursor(false, i, rowLo, rowHi);
                if (cursor.hasNext()) {
                    long row = cursor.next();
                    this.recordA.setRecordIndex(row);
                    if (!this.filter.getBool(this.recordA)) continue;
                    this.rows.add(Rows.toRowID(partitionIndex, row));
                    this.found.addAt(index, i);
                    continue;
                }
                if (i < localLo) {
                    localLo = i;
                }
                if (i <= localHi) continue;
                localHi = i;
            }
            this.rows.sortAsUnsigned();
            keyLo = localLo;
            keyHi = localHi + 1;
            localLo = Integer.MAX_VALUE;
            localHi = Integer.MIN_VALUE;
        }
    }
}

