/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestBySubQueryRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private final int columnIndex;
    private final IntHashSet symbolKeys = new IntHashSet();
    private final RecordCursorFactory recordCursorFactory;
    private final Function filter;
    private final Record.CharSequenceFunction func;

    public LatestBySubQueryRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @NotNull RecordCursorFactory recordCursorFactory, @Nullable Function filter, boolean indexed, @NotNull Record.CharSequenceFunction func, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory, configuration);
        this.cursor = indexed ? (filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, filter, columnIndexes) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, this.rows, columnIndexes)) : (filter != null ? new LatestByValuesFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, filter, columnIndexes) : new LatestByValuesRecordCursor(columnIndex, this.rows, this.symbolKeys, columnIndexes));
        this.columnIndex = columnIndex;
        this.recordCursorFactory = recordCursorFactory;
        this.filter = filter;
        this.func = func;
    }

    @Override
    public void close() {
        super.close();
        this.recordCursorFactory.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        SymbolMapReader symbolTable = dataFrameCursor.getSymbolTable(this.columnIndex);
        this.symbolKeys.clear();
        try (RecordCursor cursor = this.recordCursorFactory.getCursor(executionContext);){
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                int symbolKey = symbolTable.keyOf(this.func.get(record, 0));
                if (symbolKey == -2) continue;
                this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
        if (this.filter != null) {
            cursor = super.getCursorInstance(dataFrameCursor, executionContext);
            this.filter.init(cursor, executionContext);
            return cursor;
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }
}

