/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValueRecordCursor;
import io.questdb.std.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByValueFilteredRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final AbstractDataFrameRecordCursor cursor;
    private final Function filter;

    public LatestByValueFilteredRecordCursorFactory(RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, int symbolKey, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.cursor = filter == null ? new LatestByValueRecordCursor(columnIndex, symbolKey, columnIndexes) : new LatestByValueFilteredRecordCursor(columnIndex, symbolKey, filter, columnIndexes);
        this.filter = filter;
    }

    @Override
    public void close() {
        super.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }
}

