/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursor;

public class LatestByValueIndexedRowCursorFactory
implements RowCursorFactory {
    private final int columnIndex;
    private final int symbolKey;
    private final boolean cachedIndexReaderCursor;
    private final LatestByValueIndexedRowCursor cursor = new LatestByValueIndexedRowCursor();

    public LatestByValueIndexedRowCursorFactory(int columnIndex, int symbolKey, boolean cachedIndexReaderCursor) {
        this.columnIndex = columnIndex;
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        RowCursor cursor = dataFrame.getBitmapIndexReader(this.columnIndex, 2).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
        if (cursor.hasNext()) {
            this.cursor.of(cursor.next());
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public boolean isEntity() {
        return false;
    }
}

