/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDescendingRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class LatestByValuesRecordCursor
extends AbstractDescendingRecordListCursor {
    private final int columnIndex;
    private final IntIntHashMap map;
    private final IntHashSet symbolKeys;

    public LatestByValuesRecordCursor(int columnIndex, DirectLongList rows, IntHashSet symbolKeys, @NotNull IntList columnIndexes) {
        super(rows, columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.map = new IntIntHashMap(Numbers.ceilPow2(symbolKeys.size()));
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        DataFrame frame;
        this.prepare();
        while ((frame = this.dataFrameCursor.next()) != null) {
            int partitionIndex = frame.getPartitionIndex();
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                this.recordA.setRecordIndex(row);
                int key = TableUtils.toIndexKey(this.recordA.getInt(this.columnIndex));
                int index = this.map.keyIndex(key);
                if (index >= 0 || this.map.valueAt(index) != 0) continue;
                this.rows.add(Rows.toRowID(partitionIndex, row));
                this.map.putAt(index, key, 1);
            }
        }
    }

    private void prepare() {
        int n = this.symbolKeys.size();
        for (int i = 0; i < n; ++i) {
            this.map.put(this.symbolKeys.get(i), 0);
        }
    }
}

