/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.ObjList;

public class SequentialRowCursorFactory
implements RowCursorFactory {
    private final ObjList<? extends RowCursorFactory> cursorFactories;
    private final ObjList<RowCursor> cursors;
    private final SequentialRowCursor cursor;

    public SequentialRowCursorFactory(ObjList<? extends RowCursorFactory> cursorFactories) {
        this.cursorFactories = cursorFactories;
        this.cursors = new ObjList();
        this.cursor = new SequentialRowCursor();
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            this.cursors.extendAndSet(i, this.cursorFactories.getQuick(i).getCursor(dataFrame));
        }
        this.cursor.init();
        return this.cursor;
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) {
        RowCursorFactory.prepareCursor(this.cursorFactories, tableReader, sqlExecutionContext);
    }

    private class SequentialRowCursor
    implements RowCursor {
        private int cursorIndex = 0;
        private RowCursor currentCursor;

        private SequentialRowCursor() {
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.currentCursor.hasNext();
            if (hasNext) {
                return true;
            }
            while (this.cursorIndex < SequentialRowCursorFactory.this.cursorFactories.size() - 1) {
                this.currentCursor = (RowCursor)SequentialRowCursorFactory.this.cursors.getQuick(++this.cursorIndex);
                if (!this.currentCursor.hasNext()) continue;
                return true;
            }
            return false;
        }

        private void init() {
            this.cursorIndex = 0;
            if (this.cursorIndex < SequentialRowCursorFactory.this.cursorFactories.size() - 1) {
                this.currentCursor = (RowCursor)SequentialRowCursorFactory.this.cursors.getQuick(this.cursorIndex);
            }
        }

        @Override
        public long next() {
            return this.currentCursor.next();
        }
    }
}

