/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class TableListRecordCursorFactory
implements RecordCursorFactory {
    private static final RecordMetadata METADATA;
    private final FilesFacade ff;
    private Path path;
    private final TableListRecordCursor cursor;

    public TableListRecordCursorFactory(FilesFacade ff, CharSequence dbRoot) {
        this.ff = ff;
        this.path = new Path().of(dbRoot).$();
        this.cursor = new TableListRecordCursor();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of();
    }

    @Override
    public RecordMetadata getMetadata() {
        return METADATA;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void close() {
        if (null != this.path) {
            this.path.close();
            this.path = null;
        }
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("table", 10, null));
        METADATA = metadata;
    }

    private class TableListRecordCursor
    implements RecordCursor {
        private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
        private final TableListRecord record = new TableListRecord();
        private long findPtr = 0L;

        private TableListRecordCursor() {
        }

        @Override
        public void close() {
            if (this.findPtr > 0L) {
                TableListRecordCursorFactory.this.ff.findClose(this.findPtr);
                this.findPtr = 0L;
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            int type;
            do {
                if (this.findPtr == 0L) {
                    this.findPtr = TableListRecordCursorFactory.this.ff.findFirst(TableListRecordCursorFactory.this.path);
                    if (this.findPtr <= 0L) {
                        return false;
                    }
                } else if (TableListRecordCursorFactory.this.ff.findNext(this.findPtr) <= 0) {
                    return false;
                }
                this.nativeLPSZ.of(TableListRecordCursorFactory.this.ff.findName(this.findPtr));
            } while ((type = TableListRecordCursorFactory.this.ff.findType(this.findPtr)) != 4 || this.nativeLPSZ.charAt(0) == '.');
            return true;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toTop() {
            this.close();
        }

        @Override
        public long size() {
            return -1L;
        }

        private TableListRecordCursor of() {
            this.toTop();
            return this;
        }

        public class TableListRecord
        implements Record {
            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return TableListRecordCursor.this.nativeLPSZ;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }
}

