/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.VirtualFunctionDirectSymbolRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class VirtualRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final VirtualFunctionDirectSymbolRecordCursor cursor;
    private final ObjList<Function> functions;
    private final RecordCursorFactory baseFactory;
    private final boolean supportsRandomAccess;

    public VirtualRecordCursorFactory(RecordMetadata metadata, ObjList<Function> functions, RecordCursorFactory baseFactory) {
        super(metadata);
        this.functions = functions;
        boolean supportsRandomAccess = baseFactory.recordCursorSupportsRandomAccess();
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            if (functions.getQuick(i).supportsRandomAccess()) continue;
            supportsRandomAccess = false;
            break;
        }
        this.supportsRandomAccess = supportsRandomAccess;
        this.cursor = new VirtualFunctionDirectSymbolRecordCursor(functions, supportsRandomAccess);
        this.baseFactory = baseFactory;
    }

    @Override
    public void close() {
        Misc.freeObjList(this.functions);
        Misc.free(this.baseFactory);
    }

    public RecordCursorFactory getBaseFactory() {
        return this.baseFactory;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor cursor = this.baseFactory.getCursor(executionContext);
        Function.init(this.functions, cursor, executionContext);
        this.cursor.of(cursor);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.supportsRandomAccess;
    }
}

