/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.std.Misc;

class ExceptRecordCursor
implements RecordCursor {
    private final Map map;
    private final RecordSink recordSink;
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;
    private Record masterRecord;
    private RecordCursor symbolCursor;
    private SqlExecutionInterruptor interruptor;

    public ExceptRecordCursor(Map map, RecordSink recordSink) {
        this.map = map;
        this.recordSink = recordSink;
    }

    void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionContext executionContext) {
        this.masterCursor = masterCursor;
        this.slaveCursor = slaveCursor;
        this.masterRecord = masterCursor.getRecord();
        this.interruptor = executionContext.getSqlExecutionInterruptor();
        this.map.clear();
        this.populateSlaveMap(slaveCursor);
        this.toTop();
    }

    private void populateSlaveMap(RecordCursor cursor) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(record, this.recordSink);
            key.createValue();
            this.interruptor.checkInterrupted();
        }
    }

    @Override
    public void close() {
        Misc.free(this.masterCursor);
        Misc.free(this.slaveCursor);
        this.interruptor = null;
    }

    @Override
    public Record getRecord() {
        return this.masterRecord;
    }

    @Override
    public boolean hasNext() {
        while (this.masterCursor.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.masterRecord, this.recordSink);
            if (key.notFound()) {
                return true;
            }
            this.interruptor.checkInterrupted();
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        return this.masterCursor.getRecordB();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.masterCursor.recordAt(record, atRowId);
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.symbolCursor.getSymbolTable(columnIndex);
    }

    @Override
    public void toTop() {
        this.symbolCursor = this.masterCursor;
        this.masterCursor.toTop();
    }

    @Override
    public long size() {
        return -1L;
    }
}

