/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.sql.DelegatingRecordImpl;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.std.Misc;

class UnionAllRecordCursor
implements NoRandomAccessRecordCursor {
    private final DelegatingRecordImpl record = new DelegatingRecordImpl();
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;
    private final NextMethod nextSlave = this::nextSlave;
    private Record masterRecord;
    private Record slaveRecord;
    private NextMethod nextMethod;
    private RecordCursor symbolCursor;
    private final NextMethod nextMaster = this::nextMaster;

    UnionAllRecordCursor() {
    }

    void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
        this.masterCursor = masterCursor;
        this.slaveCursor = slaveCursor;
        this.masterRecord = masterCursor.getRecord();
        this.slaveRecord = slaveCursor.getRecord();
        this.toTop();
    }

    @Override
    public void close() {
        Misc.free(this.masterCursor);
        Misc.free(this.slaveCursor);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        return this.nextMethod.next();
    }

    private boolean nextSlave() {
        return this.slaveCursor.hasNext();
    }

    @Override
    public long size() {
        long masterSize = this.masterCursor.size();
        long slaveSize = this.slaveCursor.size();
        if (masterSize == -1L || slaveSize == -1L) {
            return -1L;
        }
        return masterSize + slaveSize;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.symbolCursor.getSymbolTable(columnIndex);
    }

    private boolean nextMaster() {
        return this.masterCursor.hasNext() || this.switchToSlaveCursor();
    }

    private boolean switchToSlaveCursor() {
        this.record.of(this.slaveRecord);
        this.nextMethod = this.nextSlave;
        this.symbolCursor = this.slaveCursor;
        return this.nextMethod.next();
    }

    @Override
    public void toTop() {
        this.record.of(this.masterRecord);
        this.nextMethod = this.nextMaster;
        this.symbolCursor = this.masterCursor;
        this.masterCursor.toTop();
        this.slaveCursor.toTop();
    }

    static interface NextMethod {
        public boolean next();
    }
}

