/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.union.UnionRecordCursor;
import io.questdb.std.Misc;

public class UnionRecordCursorFactory
implements RecordCursorFactory {
    private final RecordMetadata metadata;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final UnionRecordCursor cursor;
    private final Map map;

    public UnionRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, RecordSink recordSink, ColumnTypes valueTypes) {
        this.metadata = metadata;
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.map = MapFactory.createMap(configuration, metadata, valueTypes);
        this.cursor = new UnionRecordCursor(this.map, recordSink);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor masterCursor = null;
        RecordCursor slaveCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable ex) {
            Misc.free(masterCursor);
            Misc.free(slaveCursor);
            throw ex;
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void close() {
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.map);
    }
}

