/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableStructure;
import io.questdb.griffin.model.ColumnCastModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public class CreateTableModel
implements Mutable,
ExecutionModel,
Sinkable,
TableStructure {
    public static final ObjectFactory<CreateTableModel> FACTORY = CreateTableModel::new;
    private static final int COLUMN_FLAG_CACHED = 1;
    private static final int COLUMN_FLAG_INDEXED = 2;
    private final CharSequenceObjHashMap<ColumnCastModel> columnCastModels = new CharSequenceObjHashMap();
    private final LongList columnBits = new LongList();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final CharSequenceIntHashMap columnNameIndexMap = new CharSequenceIntHashMap();
    private ExpressionNode name;
    private QueryModel queryModel;
    private ExpressionNode timestamp;
    private ExpressionNode partitionBy;
    private int o3MaxUncommittedRows;
    private long o3CommitHysteresisInMicros;
    private boolean ignoreIfExists = false;

    private CreateTableModel() {
    }

    public boolean addColumn(CharSequence name, int type, int symbolCapacity) {
        if (this.columnNameIndexMap.put(name, this.columnNames.size())) {
            this.columnNames.add(Chars.toString(name));
            this.columnBits.add(Numbers.encodeLowHighInts(type, symbolCapacity));
            this.columnBits.add(Numbers.encodeLowHighInts(1, 0));
            return true;
        }
        return false;
    }

    public boolean addColumnCastModel(ColumnCastModel model) {
        return this.columnCastModels.put(model.getName().token, model);
    }

    public CreateTableModel cached(boolean cached) {
        int last = this.columnBits.size() - 1;
        assert (last > 0);
        assert (this.getLowAt(last - 1) == 11);
        if (cached) {
            this.columnBits.setQuick(last, Numbers.encodeLowHighInts(this.getLowAt(last) | 1, this.getHighAt(last)));
        } else {
            this.columnBits.setQuick(last, Numbers.encodeLowHighInts(this.getLowAt(last) & 0xFFFFFFFE, this.getHighAt(last)));
        }
        return this;
    }

    @Override
    public void clear() {
        this.columnCastModels.clear();
        this.queryModel = null;
        this.timestamp = null;
        this.partitionBy = null;
        this.name = null;
        this.columnBits.clear();
        this.columnNames.clear();
        this.columnNameIndexMap.clear();
        this.ignoreIfExists = false;
    }

    public CharSequenceObjHashMap<ColumnCastModel> getColumnCastModels() {
        return this.columnCastModels;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public CharSequence getColumnName(int index) {
        return this.columnNames.getQuick(index);
    }

    @Override
    public int getColumnType(int index) {
        return this.getLowAt(index * 2);
    }

    @Override
    public int getIndexBlockCapacity(int index) {
        return this.getHighAt(index * 2 + 1);
    }

    @Override
    public boolean isIndexed(int index) {
        return (this.getLowAt(index * 2 + 1) & 2) != 0;
    }

    @Override
    public boolean isSequential(int columnIndex) {
        return false;
    }

    @Override
    public int getPartitionBy() {
        return this.partitionBy == null ? 3 : PartitionBy.fromString(this.partitionBy.token);
    }

    public void setPartitionBy(ExpressionNode partitionBy) {
        this.partitionBy = partitionBy;
    }

    @Override
    public boolean getSymbolCacheFlag(int index) {
        return (this.getLowAt(index * 2 + 1) & 1) != 0;
    }

    @Override
    public int getSymbolCapacity(int index) {
        int capacity = this.getHighAt(index * 2);
        assert (capacity != -1);
        return capacity;
    }

    @Override
    public CharSequence getTableName() {
        return this.name.token;
    }

    @Override
    public int getTimestampIndex() {
        return this.timestamp == null ? -1 : this.getColumnIndex(this.timestamp.token);
    }

    public int getColumnIndex(CharSequence columnName) {
        return this.columnNameIndexMap.get(columnName);
    }

    @Override
    public int getModelType() {
        return 2;
    }

    public ExpressionNode getName() {
        return this.name;
    }

    public void setName(ExpressionNode name) {
        this.name = name;
    }

    public QueryModel getQueryModel() {
        return this.queryModel;
    }

    public void setQueryModel(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    public ExpressionNode getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(ExpressionNode timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public void setIgnoreIfExists(boolean flag) {
        this.ignoreIfExists = flag;
    }

    public void setIndexFlags(boolean indexFlag, int indexValueBlockSize) {
        this.setIndexFlags0(this.columnBits.size() - 1, indexFlag, indexValueBlockSize);
    }

    public void setIndexFlags(int columnIndex, boolean indexFlag, int indexValueBlockSize) {
        this.setIndexFlags0(columnIndex * 2 + 1, indexFlag, indexValueBlockSize);
    }

    public void symbolCapacity(int capacity) {
        int pos = this.columnBits.size() - 2;
        assert (pos > -1);
        int type = this.getLowAt(pos);
        assert (type == 11);
        this.columnBits.setQuick(pos, Numbers.encodeLowHighInts(type, capacity));
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("create table ");
        sink.put(this.getName().token);
        if (this.getQueryModel() != null) {
            sink.put(" as (");
            this.getQueryModel().toSink(sink);
            sink.put(')');
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isIndexed(i)) continue;
                sink.put(", index(");
                sink.put(this.getColumnName(i));
                sink.put(" capacity ");
                sink.put(this.getIndexBlockCapacity(i));
                sink.put(')');
            }
            ObjList<CharSequence> castColumns = this.getColumnCastModels().keys();
            int n2 = castColumns.size();
            for (int i = 0; i < n2; ++i) {
                CharSequence column = castColumns.getQuick(i);
                ColumnCastModel m = this.getColumnCastModels().get(column);
                int type = m.getColumnType();
                sink.put(", cast(");
                sink.put(column);
                sink.put(" as ");
                sink.put(ColumnType.nameOf(type));
                sink.put(':');
                sink.put(m.getColumnTypePos());
                if (type == 11) {
                    sink.put(" capacity ");
                    sink.put(m.getSymbolCapacity());
                    if (m.getSymbolCacheFlag()) {
                        sink.put(" cache");
                    } else {
                        sink.put(" nocache");
                    }
                    if (m.isIndexed()) {
                        sink.put(" index capacity ");
                        sink.put(m.getIndexValueBlockSize());
                    }
                }
                sink.put(')');
            }
        } else {
            sink.put(" (");
            int count = this.getColumnCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                sink.put(this.getColumnName(i));
                sink.put(' ');
                sink.put(ColumnType.nameOf(this.getColumnType(i)));
                if (this.getColumnType(i) == 11) {
                    sink.put(" capacity ");
                    sink.put(this.getSymbolCapacity(i));
                    if (this.getSymbolCacheFlag(i)) {
                        sink.put(" cache");
                    } else {
                        sink.put(" nocache");
                    }
                }
                if (!this.isIndexed(i)) continue;
                sink.put(" index capacity ");
                sink.put(this.getIndexBlockCapacity(i));
            }
            sink.put(')');
        }
        if (this.getTimestamp() != null) {
            sink.put(" timestamp(");
            sink.put(this.getTimestamp().token);
            sink.put(')');
        }
        if (this.partitionBy != null) {
            sink.put(" partition by ").put(this.partitionBy.token);
        }
    }

    private int getHighAt(int index) {
        return Numbers.decodeHighInt(this.columnBits.getQuick(index));
    }

    private int getLowAt(int index) {
        return Numbers.decodeLowInt(this.columnBits.getQuick(index));
    }

    private void setIndexFlags0(int index, boolean indexFlag, int indexValueBlockSize) {
        assert (index > 0);
        int flags = this.getLowAt(index);
        if (indexFlag) {
            assert (indexValueBlockSize > 1);
            this.columnBits.setQuick(index, Numbers.encodeLowHighInts(flags | 2, Numbers.ceilPow2(indexValueBlockSize)));
        } else {
            this.columnBits.setQuick(index, Numbers.encodeLowHighInts(flags & 0xFFFFFFFD, Numbers.ceilPow2(indexValueBlockSize)));
        }
    }

    @Override
    public int getO3MaxUncommittedRows() {
        return this.o3MaxUncommittedRows;
    }

    public void setO3MaxUncommittedRows(int lineTcpMaxUncommittedRows) {
        this.o3MaxUncommittedRows = lineTcpMaxUncommittedRows;
    }

    @Override
    public long getO3CommitHysteresisInMicros() {
        return this.o3CommitHysteresisInMicros;
    }

    public void setO3CommitHysteresisInMicros(long lineTcpCommitHysteresisInMicros) {
        this.o3CommitHysteresisInMicros = lineTcpCommitHysteresisInMicros;
    }
}

