/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public class ExpressionNode
implements Mutable,
Sinkable {
    public static final ExpressionNodeFactory FACTORY = new ExpressionNodeFactory();
    public static final int OPERATION = 1;
    public static final int CONSTANT = 2;
    public static final int LITERAL = 4;
    public static final int MEMBER_ACCESS = 5;
    public static final int BIND_VARIABLE = 6;
    public static final int FUNCTION = 8;
    public static final int ARRAY_ACCESS = 9;
    public static final int CONTROL = 16;
    public static final int SET_OPERATION = 32;
    public static final int QUERY = 65;
    public static final int UNKNOWN = 0;
    public final ObjList<ExpressionNode> args = new ObjList(4);
    public CharSequence token;
    public QueryModel queryModel;
    public int precedence;
    public int position;
    public ExpressionNode lhs;
    public ExpressionNode rhs;
    public int type;
    public int paramCount;
    public int intrinsicValue = 0;

    private ExpressionNode() {
    }

    public static boolean compareNodesExact(ExpressionNode a, ExpressionNode b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.type != b.type) {
            return false;
        }
        return Chars.equals(a.token, b.token) && ExpressionNode.compareArgsExact(a, b);
    }

    public static boolean compareNodesGroupBy(ExpressionNode groupByExpr, ExpressionNode columnExpr, QueryModel translatingModel) {
        if (groupByExpr == null && columnExpr == null) {
            return true;
        }
        if (groupByExpr == null || columnExpr == null || groupByExpr.type != columnExpr.type) {
            return false;
        }
        if (!Chars.equals(groupByExpr.token, columnExpr.token)) {
            int index = translatingModel.getAliasToColumnMap().keyIndex(columnExpr.token);
            if (index > -1) {
                return false;
            }
            QueryColumn qc = translatingModel.getAliasToColumnMap().valueAt(index);
            CharSequence qcTok = qc.getAst().token;
            CharSequence tok = groupByExpr.token;
            if (Chars.equals(qcTok, tok)) {
                return true;
            }
            int dot = Chars.indexOf(tok, '.');
            if (dot > -1 && translatingModel.getAliasIndex(tok, 0, dot) > -1 && Chars.equals(qcTok, tok, dot + 1, tok.length())) {
                return ExpressionNode.compareArgs(groupByExpr, columnExpr, translatingModel);
            }
            return false;
        }
        return ExpressionNode.compareArgs(groupByExpr, columnExpr, translatingModel);
    }

    @Override
    public void clear() {
        this.args.clear();
        this.token = null;
        this.precedence = 0;
        this.position = 0;
        this.lhs = null;
        this.rhs = null;
        this.type = 0;
        this.paramCount = 0;
        this.intrinsicValue = 0;
        this.queryModel = null;
    }

    public ExpressionNode of(int type, CharSequence token, int precedence, int position) {
        this.clear();
        this.type = type == 4 && token != null && (token.charAt(0) == '$' || token.charAt(0) == ':') ? 6 : type;
        this.precedence = precedence;
        this.token = token;
        this.position = position;
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        switch (this.paramCount) {
            case 0: {
                if (this.queryModel != null) {
                    sink.put('(').put(this.queryModel).put(')');
                    break;
                }
                sink.put(this.token);
                if (this.type != 8) break;
                sink.put("()");
                break;
            }
            case 1: {
                sink.put(this.token);
                sink.put('(');
                this.rhs.toSink(sink);
                sink.put(')');
                break;
            }
            case 2: {
                if (OperatorExpression.isOperator(this.token)) {
                    this.lhs.toSink(sink);
                    sink.put(' ');
                    sink.put(this.token);
                    sink.put(' ');
                    this.rhs.toSink(sink);
                    break;
                }
                sink.put(this.token);
                sink.put('(');
                this.lhs.toSink(sink);
                sink.put(',');
                this.rhs.toSink(sink);
                sink.put(')');
                break;
            }
            default: {
                int n = this.args.size();
                if (OperatorExpression.isOperator(this.token) && n > 0) {
                    this.args.getQuick(n - 1).toSink(sink);
                    sink.put(' ');
                    sink.put(this.token);
                    sink.put(' ');
                    sink.put('(');
                    for (int i = n - 2; i > -1; --i) {
                        if (i < n - 2) {
                            sink.put(',');
                        }
                        this.args.getQuick(i).toSink(sink);
                    }
                    sink.put(')');
                    break;
                }
                sink.put(this.token);
                sink.put('(');
                for (int i = n - 1; i > -1; --i) {
                    if (i < n - 1) {
                        sink.put(',');
                    }
                    this.args.getQuick(i).toSink(sink);
                }
                sink.put(')');
            }
        }
    }

    private static boolean compareArgs(ExpressionNode groupByExpr, ExpressionNode columnExpr, QueryModel translatingModel) {
        int selectNodeArgsSize;
        int groupByArgsSize = groupByExpr.args.size();
        if (groupByArgsSize != (selectNodeArgsSize = columnExpr.args.size())) {
            return false;
        }
        if (groupByArgsSize < 3) {
            return ExpressionNode.compareNodesGroupBy(groupByExpr.lhs, columnExpr.lhs, translatingModel) && ExpressionNode.compareNodesGroupBy(groupByExpr.rhs, columnExpr.rhs, translatingModel);
        }
        for (int i = 0; i < groupByArgsSize; ++i) {
            if (ExpressionNode.compareNodesGroupBy(groupByExpr.args.get(i), columnExpr.args.get(i), translatingModel)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareArgsExact(ExpressionNode a, ExpressionNode b) {
        int selectNodeArgsSize;
        int groupByArgsSize = a.args.size();
        if (groupByArgsSize != (selectNodeArgsSize = b.args.size())) {
            return false;
        }
        if (groupByArgsSize < 3) {
            return ExpressionNode.compareNodesExact(a.lhs, b.lhs) && ExpressionNode.compareNodesExact(a.rhs, b.rhs);
        }
        for (int i = 0; i < groupByArgsSize; ++i) {
            if (ExpressionNode.compareNodesExact(a.args.get(i), b.args.get(i))) continue;
            return false;
        }
        return true;
    }

    public static final class ExpressionNodeFactory
    implements ObjectFactory<ExpressionNode> {
        @Override
        public ExpressionNode newInstance() {
            return new ExpressionNode();
        }
    }
}

