/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RuntimeIntervalModelBuilder;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;

public class IntrinsicModel
implements Mutable {
    public static final ObjectFactory<IntrinsicModel> FACTORY = IntrinsicModel::new;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int UNDEFINED = 0;
    private static final LongList INFINITE_INTERVAL = new LongList();
    public final CharSequenceHashSet keyValues = new CharSequenceHashSet();
    public final CharSequenceHashSet keyExcludedValues = new CharSequenceHashSet();
    public final IntList keyValuePositions = new IntList();
    public final IntList keyExcludedValuePositions = new IntList();
    public CharSequence keyColumn;
    public ExpressionNode filter;
    public int intrinsicValue = 0;
    public QueryModel keySubQuery;
    private final RuntimeIntervalModelBuilder runtimeIntervalBuilder = new RuntimeIntervalModelBuilder();

    @Override
    public void clear() {
        this.keyColumn = null;
        this.keyValues.clear();
        this.keyExcludedValues.clear();
        this.keyValuePositions.clear();
        this.keyExcludedValuePositions.clear();
        this.runtimeIntervalBuilder.clear();
        this.filter = null;
        this.intrinsicValue = 0;
        this.keySubQuery = null;
    }

    public void excludeValue(ExpressionNode val) {
        int index;
        if (SqlKeywords.isNullKeyword(val.token)) {
            index = this.keyValues.removeNull();
            if (index > -1) {
                this.keyValuePositions.removeIndex(index);
            }
        } else {
            int keyIndex;
            int n = keyIndex = Chars.isQuoted(val.token) ? this.keyValues.keyIndex(val.token, 1, val.token.length() - 1) : this.keyValues.keyIndex(val.token);
            if (keyIndex < 0) {
                index = this.keyValues.getListIndexAt(keyIndex);
                this.keyValues.removeAt(keyIndex);
            } else {
                index = -1;
            }
        }
        if (index > -1) {
            this.keyValuePositions.removeIndex(index);
        }
        if (this.keyValues.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    public RuntimeIntrinsicIntervalModel buildIntervalModel() {
        return this.runtimeIntervalBuilder.build();
    }

    public boolean hasIntervalFilters() {
        return this.runtimeIntervalBuilder.hasIntervalFilters();
    }

    public void intersectEmpty() {
        this.runtimeIntervalBuilder.intersectEmpty();
        this.intrinsicValue = 2;
    }

    public void intersectEquals(Function function) {
        this.runtimeIntervalBuilder.intersectEquals(function);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.intersect(lo, hi);
    }

    public void setBetweenBoundary(long timestamp) {
        this.runtimeIntervalBuilder.setBetweenBoundary(timestamp);
    }

    public void setBetweenBoundary(Function timestamp) {
        this.runtimeIntervalBuilder.setBetweenBoundary(timestamp);
    }

    public void setBetweenNegated(boolean isNegated) {
        this.runtimeIntervalBuilder.setBetweenNegated(isNegated);
    }

    public void clearBetweenTempParsing() {
        this.runtimeIntervalBuilder.clearBetweenParsing();
    }

    public void unionIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.union(lo, hi);
    }

    public void intersectTimestamp(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.intersectTimestamp(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.intersectIntervals(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, Function function, short funcAdjust) {
        this.runtimeIntervalBuilder.intersect(lo, function, funcAdjust);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(Function function, long hi, short funcAdjust) {
        this.runtimeIntervalBuilder.intersect(function, hi, funcAdjust);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void subtractIntervals(long lo, long hi) {
        this.runtimeIntervalBuilder.subtractInterval(lo, hi);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public void subtractIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        this.runtimeIntervalBuilder.subtractIntervals(seq, lo, lim, position);
        if (this.runtimeIntervalBuilder.isEmptySet()) {
            this.intrinsicValue = 2;
        }
    }

    public String toString() {
        return "IntrinsicModel{keyValues=" + this.keyValues + ", keyColumn='" + this.keyColumn + '\'' + ", filter=" + this.filter + '}';
    }

    static {
        INFINITE_INTERVAL.add(Long.MIN_VALUE);
        INFINITE_INTERVAL.add(Long.MAX_VALUE);
    }
}

