/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class RuntimeIntervalModel
implements RuntimeIntrinsicIntervalModel {
    private final LongList intervals;
    private final ObjList<Function> dynamicRangeList;
    private LongList outIntervals;

    public RuntimeIntervalModel(LongList intervals) {
        this(intervals, null);
    }

    public RuntimeIntervalModel(LongList staticIntervals, ObjList<Function> dynamicRangeList) {
        this.intervals = staticIntervals;
        this.dynamicRangeList = dynamicRangeList;
    }

    @Override
    public LongList calculateIntervals(SqlExecutionContext sqlContext) {
        if (this.isStatic()) {
            return this.intervals;
        }
        if (this.outIntervals == null) {
            this.outIntervals = new LongList();
        } else {
            this.outIntervals.clear();
        }
        int dynamicStart = this.intervals.size() - this.dynamicRangeList.size() * 4;
        this.outIntervals.add(this.intervals, 0, dynamicStart);
        this.addEvaluateDynamicIntervals(this.outIntervals, sqlContext);
        return this.outIntervals;
    }

    @Override
    public boolean allIntervalsHitOnePartition(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return this.allIntervalsHitOnePartition(Timestamps.FLOOR_DD);
            }
            case 1: {
                return this.allIntervalsHitOnePartition(Timestamps.FLOOR_MM);
            }
            case 2: {
                return this.allIntervalsHitOnePartition(Timestamps.FLOOR_YYYY);
            }
        }
        return true;
    }

    private boolean allIntervalsHitOnePartition(Timestamps.TimestampFloorMethod floorMethod) {
        if (!this.isStatic()) {
            return false;
        }
        if (this.intervals.size() == 0) {
            return true;
        }
        long floor = floorMethod.floor(this.intervals.getQuick(0));
        int n = this.intervals.size();
        for (int i = 1; i < n; ++i) {
            if (floor == floorMethod.floor(this.intervals.getQuick(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        Misc.freeObjList(this.dynamicRangeList);
    }

    private void addEvaluateDynamicIntervals(LongList outIntervals, SqlExecutionContext sqlContext) {
        int size = this.intervals.size();
        int dynamicStart = size - this.dynamicRangeList.size() * 4;
        int dynamicIndex = 0;
        block4: for (int i = dynamicStart; i < size; i += 4) {
            Function dynamicFunction = this.dynamicRangeList.getQuick(dynamicIndex++);
            short operation = IntervalUtils.getEncodedOperation(this.intervals, i);
            boolean negated = operation > 3;
            int divider = outIntervals.size();
            if (dynamicFunction == null) {
                outIntervals.add(this.intervals, i, i + 4);
                IntervalUtils.applyLastEncodedIntervalEx(outIntervals);
            } else {
                long lo = IntervalUtils.getEncodedPeriodLo(this.intervals, i);
                long hi = IntervalUtils.getEncodedPeriodHi(this.intervals, i);
                short adjustment = IntervalUtils.getEncodedAdjustment(this.intervals, i);
                short dynamicHiLo = IntervalUtils.getEncodedDynamicIndicator(this.intervals, i);
                dynamicFunction.init(null, sqlContext);
                long dynamicValue = this.getTimestamp(dynamicFunction);
                long dynamicValue2 = 0L;
                if (dynamicHiLo == 4) {
                    i += 4;
                    dynamicFunction = this.dynamicRangeList.getQuick(dynamicIndex++);
                    dynamicFunction.init(null, sqlContext);
                    dynamicValue2 = hi = this.getTimestamp(dynamicFunction);
                    lo = dynamicValue;
                } else {
                    if ((dynamicHiLo & 2) != 0) {
                        hi = dynamicValue + (long)adjustment;
                    }
                    if ((dynamicHiLo & 1) != 0) {
                        lo = dynamicValue + (long)adjustment;
                    }
                }
                if (dynamicValue == Long.MIN_VALUE || dynamicValue2 == Long.MIN_VALUE) {
                    if (!negated) {
                        outIntervals.clear();
                        return;
                    }
                    this.checkAddAll(outIntervals);
                    continue;
                }
                if (operation == 3 || operation == 5) {
                    long tempHi = Math.max(hi, lo);
                    lo = Math.min(hi, lo);
                    hi = tempHi;
                }
                outIntervals.extendAndSet(divider + 1, hi);
                outIntervals.setQuick(divider, lo);
            }
            if (divider <= 0) continue;
            switch (operation) {
                case 1: 
                case 3: {
                    IntervalUtils.intersectInplace(outIntervals, divider);
                    continue block4;
                }
                case 4: 
                case 5: {
                    IntervalUtils.subtract(outIntervals, divider);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Interval operation " + operation + " is not supported");
                }
            }
        }
    }

    private void checkAddAll(LongList outIntervals) {
        if (outIntervals.size() == 0) {
            outIntervals.extendAndSet(1, Long.MAX_VALUE);
            outIntervals.extendAndSet(0, Long.MIN_VALUE);
        }
    }

    private long getTimestamp(Function dynamicFunction) {
        if (dynamicFunction.getType() == 10) {
            CharSequence value = dynamicFunction.getStr(null);
            try {
                return IntervalUtils.parseFloorPartialDate(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
        return dynamicFunction.getTimestamp(null);
    }

    private boolean isStatic() {
        return this.dynamicRangeList == null || this.dynamicRangeList.size() == 0;
    }
}

