/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.RuntimeIntervalModel;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;

public class RuntimeIntervalModelBuilder
implements Mutable {
    private final LongList staticIntervals = new LongList();
    private final ObjList<Function> dynamicRangeList = new ObjList();
    private boolean intervalApplied = false;
    private long betweenBoundary;
    private Function betweenBoundaryFunc;
    private boolean betweenBoundarySet;
    private boolean betweenNegated;

    public RuntimeIntrinsicIntervalModel build() {
        return new RuntimeIntervalModel(new LongList(this.staticIntervals), new ObjList<Function>(this.dynamicRangeList));
    }

    @Override
    public void clear() {
        this.staticIntervals.clear();
        this.dynamicRangeList.clear();
        this.intervalApplied = false;
        this.clearBetweenParsing();
    }

    public void clearBetweenParsing() {
        this.betweenBoundarySet = false;
        this.betweenBoundaryFunc = null;
        this.betweenBoundary = Long.MIN_VALUE;
    }

    public boolean hasIntervalFilters() {
        return this.intervalApplied;
    }

    public void intersect(long lo, Function hi, short adjustment) {
        if (this.isEmptySet()) {
            return;
        }
        IntervalUtils.addHiLoInterval(lo, 0L, adjustment, (short)2, (short)1, this.staticIntervals);
        this.dynamicRangeList.add(hi);
        this.intervalApplied = true;
    }

    public void intersect(Function lo, long hi, short adjustment) {
        if (this.isEmptySet()) {
            return;
        }
        IntervalUtils.addHiLoInterval(0L, hi, adjustment, (short)1, (short)1, this.staticIntervals);
        this.dynamicRangeList.add(lo);
        this.intervalApplied = true;
    }

    public void intersect(long lo, long hi) {
        if (this.isEmptySet()) {
            return;
        }
        if (this.dynamicRangeList.size() == 0) {
            this.staticIntervals.add(lo);
            this.staticIntervals.add(hi);
            if (this.intervalApplied) {
                IntervalUtils.intersectInplace(this.staticIntervals, this.staticIntervals.size() - 2);
            }
        } else {
            IntervalUtils.addHiLoInterval(lo, hi, (short)1, this.staticIntervals);
            this.dynamicRangeList.add(null);
        }
        this.intervalApplied = true;
    }

    public void setBetweenNegated(boolean isNegated) {
        this.betweenNegated = isNegated;
    }

    public void setBetweenBoundary(long timestamp) {
        if (!this.betweenBoundarySet) {
            this.betweenBoundary = timestamp;
            this.betweenBoundarySet = true;
        } else {
            if (this.betweenBoundaryFunc == null) {
                long lo = Math.min(timestamp, this.betweenBoundary);
                long hi = Math.max(timestamp, this.betweenBoundary);
                if (hi == Long.MIN_VALUE || lo == Long.MIN_VALUE) {
                    if (!this.betweenNegated) {
                        this.intersectEmpty();
                    }
                } else if (!this.betweenNegated) {
                    this.intersect(lo, hi);
                } else {
                    this.subtractInterval(lo, hi);
                }
            } else {
                this.intersectBetweenSemiDynamic(this.betweenBoundaryFunc, timestamp);
            }
            this.betweenBoundarySet = false;
        }
    }

    public void setBetweenBoundary(Function timestamp) {
        if (!this.betweenBoundarySet) {
            this.betweenBoundaryFunc = timestamp;
            this.betweenBoundarySet = true;
        } else {
            if (this.betweenBoundaryFunc == null) {
                this.intersectBetweenSemiDynamic(timestamp, this.betweenBoundary);
            } else {
                this.intersectBetweenDynamic(timestamp, this.betweenBoundaryFunc);
            }
            this.betweenBoundarySet = false;
        }
    }

    private void intersectBetweenSemiDynamic(Function funcValue, long constValue) {
        if (constValue == Long.MIN_VALUE) {
            if (!this.betweenNegated) {
                this.intersectEmpty();
            }
            return;
        }
        if (this.isEmptySet()) {
            return;
        }
        short operation = this.betweenNegated ? (short)5 : 3;
        IntervalUtils.addHiLoInterval(constValue, 0L, (short)0, (short)2, operation, this.staticIntervals);
        this.dynamicRangeList.add(funcValue);
        this.intervalApplied = true;
    }

    private void intersectBetweenDynamic(Function funcValue1, Function funcValue2) {
        if (this.isEmptySet()) {
            return;
        }
        short operation = this.betweenNegated ? (short)5 : 3;
        IntervalUtils.addHiLoInterval(0L, 0L, (short)0, (short)4, operation, this.staticIntervals);
        IntervalUtils.addHiLoInterval(0L, 0L, (short)0, (short)4, operation, this.staticIntervals);
        this.dynamicRangeList.add(funcValue1);
        this.dynamicRangeList.add(funcValue2);
        this.intervalApplied = true;
    }

    public void union(long lo, long hi) {
        if (this.isEmptySet()) {
            return;
        }
        if (this.dynamicRangeList.size() == 0) {
            this.staticIntervals.add(lo);
            this.staticIntervals.add(hi);
            if (this.intervalApplied) {
                IntervalUtils.unionInplace(this.staticIntervals, this.staticIntervals.size() - 2);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.intervalApplied = true;
    }

    public void intersectEmpty() {
        this.clear();
        this.intervalApplied = true;
    }

    public void intersectEquals(Function function) {
        if (this.isEmptySet()) {
            return;
        }
        IntervalUtils.addHiLoInterval(0L, 0L, (short)0, (short)3, (short)1, this.staticIntervals);
        this.dynamicRangeList.add(function);
        this.intervalApplied = true;
    }

    public void intersectTimestamp(CharSequence seq, int lo, int lim, int position) throws SqlException {
        if (this.isEmptySet()) {
            return;
        }
        int size = this.staticIntervals.size();
        IntervalUtils.parseSingleTimestamp(seq, lo, lim, position, this.staticIntervals, (short)1);
        if (this.dynamicRangeList.size() == 0) {
            IntervalUtils.applyLastEncodedIntervalEx(this.staticIntervals);
            if (this.intervalApplied) {
                IntervalUtils.intersectInplace(this.staticIntervals, size);
            }
        } else {
            this.dynamicRangeList.add(null);
        }
        this.intervalApplied = true;
    }

    public void intersectIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        if (this.isEmptySet()) {
            return;
        }
        int size = this.staticIntervals.size();
        IntervalUtils.parseIntervalEx(seq, lo, lim, position, this.staticIntervals, (short)1);
        if (this.dynamicRangeList.size() == 0) {
            IntervalUtils.applyLastEncodedIntervalEx(this.staticIntervals);
            if (this.intervalApplied) {
                IntervalUtils.intersectInplace(this.staticIntervals, size);
            }
        } else {
            this.dynamicRangeList.add(null);
        }
        this.intervalApplied = true;
    }

    public boolean isEmptySet() {
        return this.intervalApplied && this.staticIntervals.size() == 0;
    }

    public void subtractInterval(long lo, long hi) {
        if (this.isEmptySet()) {
            return;
        }
        if (this.dynamicRangeList.size() == 0) {
            int size = this.staticIntervals.size();
            this.staticIntervals.add(lo);
            this.staticIntervals.add(hi);
            IntervalUtils.invert(this.staticIntervals, size);
            if (this.intervalApplied) {
                IntervalUtils.intersectInplace(this.staticIntervals, size);
            }
        } else {
            IntervalUtils.addHiLoInterval(lo, hi, (short)4, this.staticIntervals);
            this.dynamicRangeList.add(null);
        }
        this.intervalApplied = true;
    }

    public void subtractIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        if (this.isEmptySet()) {
            return;
        }
        int size = this.staticIntervals.size();
        IntervalUtils.parseIntervalEx(seq, lo, lim, position, this.staticIntervals, (short)4);
        if (this.dynamicRangeList.size() == 0) {
            IntervalUtils.applyLastEncodedIntervalEx(this.staticIntervals);
            IntervalUtils.invert(this.staticIntervals, size);
            if (this.intervalApplied) {
                IntervalUtils.intersectInplace(this.staticIntervals, size);
            }
        } else {
            this.dynamicRangeList.add(null);
        }
        this.intervalApplied = true;
    }
}

