/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class LogRecordSink
extends AbstractCharSink
implements Closeable {
    private final long address;
    private final long lim;
    private long _wptr;
    private int level;

    LogRecordSink(int capacity) {
        int c = Numbers.ceilPow2(capacity);
        this.address = this._wptr = Unsafe.malloc(c);
        this.lim = this.address + (long)c;
    }

    public void clear(int len) {
        this._wptr = this.address + (long)len;
    }

    @Override
    public void close() {
        Unsafe.free(this.address, this.lim - this.address);
    }

    public long getAddress() {
        return this.address;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public CharSink put(CharSequence cs) {
        int rem = (int)(this.lim - this._wptr);
        int len = cs.length();
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int rem = (int)(this.lim - this._wptr);
        int len = hi - lo;
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, lo, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this._wptr < this.lim) {
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
        }
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        if (this._wptr + (long)len < this.lim) {
            Chars.asciiCopyTo(chars, start, len, this._wptr);
            this._wptr += (long)len;
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        long hi = this._wptr;
        for (long p = this.address; p < hi; ++p) {
            b.append((char)Unsafe.getUnsafe().getByte(p));
        }
        return b.toString();
    }
}

