/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;

public class RingQueue<T>
implements Closeable {
    private final int mask;
    private final T[] buf;

    public RingQueue(ObjectFactory<T> factory, int cycle) {
        this.mask = cycle - 1;
        this.buf = new Object[cycle];
        for (int i = 0; i < cycle; ++i) {
            this.buf[i] = factory.newInstance();
        }
    }

    @Override
    public void close() {
        int n = this.buf.length;
        for (int i = 0; i < n; ++i) {
            Misc.free(this.buf[i]);
        }
    }

    public T get(long cursor) {
        return this.buf[(int)(cursor & (long)this.mask)];
    }

    public int getCapacity() {
        return this.buf.length;
    }
}

