/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.std.LongMatrix;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractIODispatcher<C extends IOContext>
extends SynchronizedJob
implements IODispatcher<C>,
EagerThreadSetup {
    protected static final int M_TIMESTAMP = 0;
    protected static final int M_FD = 1;
    protected final Log LOG;
    protected final RingQueue<IOEvent<C>> interestQueue;
    protected final MPSequence interestPubSeq;
    protected final SCSequence interestSubSeq;
    protected final long serverFd;
    protected final RingQueue<IOEvent<C>> ioEventQueue;
    protected final SPSequence ioEventPubSeq;
    protected final MCSequence ioEventSubSeq;
    protected final MillisecondClock clock;
    protected final int activeConnectionLimit;
    protected final IOContextFactory<C> ioContextFactory;
    protected final NetworkFacade nf;
    protected final int initialBias;
    protected final AtomicInteger connectionCount = new AtomicInteger();
    protected final RingQueue<IOEvent<C>> disconnectQueue;
    protected final MPSequence disconnectPubSeq;
    protected final SCSequence disconnectSubSeq;
    protected final QueueConsumer<IOEvent<C>> disconnectContextRef = this::disconnectContext;
    protected final long idleConnectionTimeout;
    protected final LongMatrix<C> pending = new LongMatrix(4);
    private final int sndBufSize;
    private final int rcvBufSize;

    public AbstractIODispatcher(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        this.LOG = LogFactory.getLog(configuration.getDispatcherLogName());
        this.nf = configuration.getNetworkFacade();
        this.serverFd = this.nf.socketTcp(false);
        this.interestQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getInterestQueueCapacity());
        this.interestPubSeq = new MPSequence(this.interestQueue.getCapacity());
        this.interestSubSeq = new SCSequence();
        this.interestPubSeq.then(this.interestSubSeq).then(this.interestPubSeq);
        this.ioEventQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.ioEventPubSeq = new SPSequence(configuration.getIOQueueCapacity());
        this.ioEventSubSeq = new MCSequence(configuration.getIOQueueCapacity());
        this.ioEventPubSeq.then(this.ioEventSubSeq).then(this.ioEventPubSeq);
        this.disconnectQueue = new RingQueue<IOEvent>(IOEvent::new, configuration.getIOQueueCapacity());
        this.disconnectPubSeq = new MPSequence(this.disconnectQueue.getCapacity());
        this.disconnectSubSeq = new SCSequence();
        this.disconnectPubSeq.then(this.disconnectSubSeq).then(this.disconnectPubSeq);
        this.clock = configuration.getClock();
        this.activeConnectionLimit = configuration.getActiveConnectionLimit();
        this.ioContextFactory = ioContextFactory;
        this.initialBias = configuration.getInitialBias();
        this.idleConnectionTimeout = configuration.getIdleConnectionTimeout() > 0L ? configuration.getIdleConnectionTimeout() : Long.MIN_VALUE;
        this.sndBufSize = configuration.getSndBufSize();
        this.rcvBufSize = configuration.getRcvBufSize();
        if (!this.nf.bindTcp(this.serverFd, configuration.getBindIPv4Address(), configuration.getBindPort())) {
            throw NetworkError.instance(this.nf.errno()).couldNotBindSocket(configuration.getDispatcherLogName(), configuration.getBindIPv4Address(), configuration.getBindPort());
        }
        this.nf.listen(this.serverFd, configuration.getListenBacklog());
    }

    @Override
    public void setup() {
        if (this.ioContextFactory instanceof EagerThreadSetup) {
            ((EagerThreadSetup)((Object)this.ioContextFactory)).setup();
        }
    }

    @Override
    public void close() {
        this.processDisconnects();
        this.nf.close(this.serverFd, this.LOG);
        int n = this.pending.size();
        for (int i = 0; i < n; ++i) {
            this.doDisconnect((IOContext)this.pending.get(i));
        }
        this.interestSubSeq.consumeAll(this.interestQueue, this.disconnectContextRef);
        this.ioEventSubSeq.consumeAll(this.ioEventQueue, this.disconnectContextRef);
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    @Override
    public void registerChannel(C context, int operation) {
        long cursor = this.interestPubSeq.nextBully();
        IOEvent<C> evt = this.interestQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.LOG.debug().$("queuing [fd=").$(context.getFd()).$(", op=").$(operation).$(']').$();
        this.interestPubSeq.done(cursor);
    }

    @Override
    public boolean processIOQueue(IORequestProcessor<C> processor) {
        long cursor = this.ioEventSubSeq.next();
        while (cursor == -2L) {
            cursor = this.ioEventSubSeq.next();
        }
        if (cursor > -1L) {
            IOEvent<C> event = this.ioEventQueue.get(cursor);
            Object connectionContext = event.context;
            int operation = event.operation;
            this.ioEventSubSeq.done(cursor);
            processor.onRequest(operation, connectionContext);
            return true;
        }
        return false;
    }

    @Override
    public void disconnect(C context) {
        long cursor = this.disconnectPubSeq.nextBully();
        assert (cursor > -1L);
        this.disconnectQueue.get((long)cursor).context = context;
        this.disconnectPubSeq.done(cursor);
    }

    protected void accept(long timestamp) {
        while (this.connectionCount.get() < this.activeConnectionLimit) {
            long fd = this.nf.accept(this.serverFd);
            if (fd < 0L) {
                if (this.nf.errno() != Net.EWOULDBLOCK) {
                    this.LOG.error().$("could not accept [ret=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                }
                return;
            }
            if (this.nf.configureNonBlocking(fd) < 0) {
                this.LOG.error().$("could not configure non-blocking [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                this.nf.close(fd, this.LOG);
                return;
            }
            if (this.nf.setTcpNoDelay(fd, true) < 0) {
                this.LOG.error().$("could not configure no delay [fd=").$(fd).$(", errno=").$(this.nf.errno()).$(']').$();
                this.nf.close(fd, this.LOG);
                return;
            }
            if (this.sndBufSize > 0) {
                this.nf.setSndBuf(fd, this.sndBufSize);
            }
            if (this.rcvBufSize > 0) {
                this.nf.setRcvBuf(fd, this.rcvBufSize);
            }
            this.LOG.info().$("connected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(']').$();
            this.connectionCount.incrementAndGet();
            this.addPending(fd, timestamp);
        }
    }

    private void addPending(long fd, long timestamp) {
        int r = this.pending.addRow();
        this.LOG.debug().$("pending [row=").$(r).$(", fd=").$(fd).$(']').$();
        this.pending.set(r, 0, timestamp);
        this.pending.set(r, 1, fd);
        this.pending.set(r, this.ioContextFactory.newInstance(fd, this));
        this.pendingAdded(r);
    }

    private void disconnectContext(IOEvent<C> event) {
        this.doDisconnect(event.context);
    }

    protected void doDisconnect(C context) {
        if (context == null || context.invalid()) {
            return;
        }
        long fd = context.getFd();
        this.LOG.info().$("disconnected [ip=").$ip(this.nf.getPeerIP(fd)).$(", fd=").$(fd).$(']').$();
        this.nf.close(fd, this.LOG);
        this.ioContextFactory.done(context);
        this.connectionCount.decrementAndGet();
    }

    protected void logSuccess(IODispatcherConfiguration configuration) {
        this.LOG.advisory().$("listening on ").$(configuration.getBindIPv4Address()).$(':').$(configuration.getBindPort()).$(" [fd=").$(this.serverFd).$(']').$();
    }

    protected abstract void pendingAdded(int var1);

    protected void processDisconnects() {
        this.disconnectSubSeq.consumeAll(this.disconnectQueue, this.disconnectContextRef);
    }

    protected void publishOperation(int operation, C context) {
        long cursor = this.ioEventPubSeq.nextBully();
        IOEvent<C> evt = this.ioEventQueue.get(cursor);
        evt.context = context;
        evt.operation = operation;
        this.ioEventPubSeq.done(cursor);
        this.LOG.debug().$("fired [fd=").$(context.getFd()).$(", op=").$(evt.operation).$(", pos=").$(cursor).$(']').$();
    }
}

