/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.SelectAccessor;
import io.questdb.network.SelectFacade;
import io.questdb.std.LongIntHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class IODispatcherWindows<C extends IOContext>
extends AbstractIODispatcher<C> {
    private static final int M_OPERATION = 2;
    private final FDSet readFdSet;
    private final FDSet writeFdSet;
    private final LongIntHashMap fds = new LongIntHashMap();
    private final SelectFacade sf;

    public IODispatcherWindows(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.readFdSet = new FDSet(configuration.getEventCapacity());
        this.writeFdSet = new FDSet(configuration.getEventCapacity());
        this.sf = configuration.getSelectFacade();
        int r = this.pending.addRow();
        this.pending.set(r, 0, this.clock.getTicks());
        this.pending.set(r, 1, this.serverFd);
        this.pending.set(r, 2, 1L);
        this.readFdSet.add(this.serverFd);
        this.readFdSet.setCount(1);
        this.writeFdSet.setCount(0);
        this.logSuccess(configuration);
    }

    @Override
    public void close() {
        super.close();
        this.readFdSet.close();
        this.writeFdSet.close();
        this.LOG.info().$("closed").$();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 2, this.initialBias == 1 ? 1L : 4L);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            useful = true;
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int operation = evt.operation;
            this.interestSubSeq.done(cursor);
            int r = this.pending.addRow();
            this.pending.set(r, 0, timestamp);
            this.pending.set(r, 1, context.getFd());
            this.pending.set(r, 2, operation);
            this.pending.set(r, context);
        }
        return useful;
    }

    private void queryFdSets(long timestamp) {
        long fd;
        int i;
        int n = this.readFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.readFdSet.get(i);
            if (fd == this.serverFd) {
                this.accept(timestamp);
                continue;
            }
            this.fds.put(fd, 1);
        }
        n = this.writeFdSet.getCount();
        for (i = 0; i < n; ++i) {
            fd = this.writeFdSet.get(i);
            int index = this.fds.keyIndex(fd);
            if (this.fds.valueAt(index) == -1) {
                this.fds.putAt(index, fd, 2);
                continue;
            }
            this.fds.putAt(index, fd, 3);
        }
    }

    @Override
    protected boolean runSerially() {
        this.processDisconnects();
        int count = this.sf.select(this.readFdSet.address, this.writeFdSet.address, 0L);
        if (count < 0) {
            this.LOG.error().$("Error in select(): ").$(this.nf.errno()).$();
            return false;
        }
        long timestamp = this.clock.getTicks();
        boolean useful = false;
        this.fds.clear();
        if (count > 0) {
            this.queryFdSets(timestamp);
            useful = true;
        }
        useful = this.processRegistrations(timestamp) | useful;
        int readFdCount = 0;
        int writeFdCount = 0;
        this.readFdSet.reset();
        this.writeFdSet.reset();
        long deadline = timestamp - this.idleConnectionTimeout;
        int i = 0;
        int n = this.pending.size();
        while (i < n) {
            long ts = this.pending.get(i, 0);
            long fd = this.pending.get(i, 1);
            int _new_op = this.fds.get(fd);
            if (_new_op == -1) {
                if (ts < deadline && fd != this.serverFd) {
                    this.doDisconnect((IOContext)this.pending.get(i));
                    this.pending.deleteRow(i);
                    --n;
                    useful = true;
                    continue;
                }
                if (this.pending.get(i++, 2) == 1L) {
                    this.readFdSet.add(fd);
                    ++readFdCount;
                    continue;
                }
                this.writeFdSet.add(fd);
                ++writeFdCount;
                continue;
            }
            IOContext context = (IOContext)this.pending.get(i);
            if ((_new_op & 1) > 0) {
                this.publishOperation(1, context);
            }
            if ((_new_op & 2) > 0) {
                this.publishOperation(4, context);
            }
            this.pending.deleteRow(i);
            --n;
        }
        this.readFdSet.setCount(readFdCount);
        this.writeFdSet.setCount(writeFdCount);
        return useful;
    }

    private static class FDSet {
        private long address;
        private int size;
        private long _wptr;
        private long lim;

        private FDSet(int size) {
            int l = SelectAccessor.ARRAY_OFFSET + 8 * size;
            this.address = Unsafe.malloc(l);
            this.size = size;
            this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
            this.lim = this.address + (long)l;
        }

        private void add(long fd) {
            if (this._wptr == this.lim) {
                this.resize();
            }
            long p = this._wptr;
            Unsafe.getUnsafe().putLong(p, fd);
            this._wptr = p + 8L;
        }

        private void close() {
            if (this.address != 0L) {
                Unsafe.free(this.address, this.lim - this.address);
                this.address = 0L;
            }
        }

        private long get(int index) {
            return Unsafe.getUnsafe().getLong(this.address + (long)SelectAccessor.ARRAY_OFFSET + (long)index * 8L);
        }

        private int getCount() {
            return Unsafe.getUnsafe().getInt(this.address + (long)SelectAccessor.COUNT_OFFSET);
        }

        private void setCount(int count) {
            Unsafe.getUnsafe().putInt(this.address + (long)SelectAccessor.COUNT_OFFSET, count);
        }

        private void reset() {
            this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
        }

        private void resize() {
            int sz = this.size * 2;
            int l = SelectAccessor.ARRAY_OFFSET + 8 * sz;
            long _addr = Unsafe.malloc(l);
            Vect.memcpy(this.address, _addr, this.lim - this.address);
            Unsafe.free(this.address, this.lim - this.address);
            this.lim = _addr + (long)l;
            this.size = sz;
            this._wptr = _addr + (this._wptr - this.address);
            this.address = _addr;
        }
    }
}

