/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public abstract class AbstractLowerCaseAsciiCharSequenceHashSet
implements Mutable {
    protected static final CharSequence noEntryKey = null;
    protected static final int MIN_INITIAL_CAPACITY = 16;
    protected final double loadFactor;
    protected int mask;
    protected int free;
    protected int capacity;
    protected CharSequence[] keys;

    public AbstractLowerCaseAsciiCharSequenceHashSet(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.free = this.capacity = Math.max(initialCapacity, 16);
        this.loadFactor = loadFactor;
        this.keys = new CharSequence[Numbers.ceilPow2((int)((double)this.capacity / loadFactor))];
        this.mask = this.keys.length - 1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, noEntryKey);
        this.free = this.capacity;
    }

    public boolean excludes(CharSequence key) {
        return this.keyIndex(key) > -1;
    }

    public boolean excludes(CharSequence key, int lo, int hi) {
        return this.keyIndex(key, lo, hi) > -1;
    }

    public int keyIndex(CharSequence key) {
        int index = Chars.lowerCaseAsciiHashCode(key) & this.mask;
        if (this.keys[index] == noEntryKey) {
            return index;
        }
        if (Chars.equalsLowerCaseAscii(key, this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public int keyIndex(CharSequence key, int lo, int hi) {
        int index = Chars.lowerCaseAsciiHashCode(key, lo, hi) & this.mask;
        if (this.keys[index] == noEntryKey) {
            return index;
        }
        CharSequence cs = this.keys[index];
        if (Chars.equalsLowerCaseAscii(key, lo, hi, cs, 0, cs.length())) {
            return -index - 1;
        }
        return this.probe(key, lo, hi, index);
    }

    public int remove(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            CharSequence key = this.keys[from];
            while (key != noEntryKey) {
                int to;
                int idealHit = Chars.lowerCaseAsciiHashCode(key) & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != noEntryKey ? this.probe(key, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    protected abstract void erase(int var1);

    protected abstract void move(int var1, int var2);

    private int probe(CharSequence key, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != noEntryKey) continue;
            return index;
        } while (!Chars.equalsLowerCaseAscii(key, this.keys[index]));
        return -index - 1;
    }

    private int probe(CharSequence key, int lo, int hi, int index) {
        CharSequence cs;
        do {
            if (this.keys[index = index + 1 & this.mask] != noEntryKey) continue;
            return index;
        } while (!Chars.equalsLowerCaseAscii(key, lo, hi, cs = this.keys[index], 0, cs.length()));
        return -index - 1;
    }
}

