/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class DirectLongList
implements Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(DirectLongList.class);
    long pos;
    long start;
    long limit;
    private long address;
    private long capacity;

    public DirectLongList(long capacity) {
        this.capacity = capacity * 8L;
        this.start = this.pos = (this.address = Unsafe.malloc(this.capacity));
        this.limit = this.pos + this.capacity;
    }

    public void add(long x) {
        this.ensureCapacity();
        assert (this.pos < this.limit);
        Unsafe.getUnsafe().putLong(this.pos, x);
        this.pos += 8L;
    }

    public final void add(DirectLongList that) {
        long thatCapacity = that.limit - that.pos;
        if (this.limit - this.pos < thatCapacity) {
            this.extend(this.capacity + thatCapacity - (this.limit - this.pos));
        }
        Vect.memcpy(that.start, this.pos, thatCapacity);
        this.pos += thatCapacity;
    }

    public void sortAsUnsigned() {
        Vect.sortULongAscInPlace(this.address, this.size());
    }

    public long binarySearch(long v) {
        long low = 0L;
        long high = (this.pos - this.start >> 3) - 1L;
        while (low <= high) {
            if (high - low < 65L) {
                return this.scanSearch(v, low, high);
            }
            long mid = low + high >>> 1;
            long midVal = Unsafe.getUnsafe().getLong(this.start + (mid << 3));
            if (midVal < v) {
                low = mid + 1L;
                continue;
            }
            if (midVal > v) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    @Override
    public void clear() {
        this.clear(0L);
    }

    public void clear(long b) {
        this.pos = this.start;
        this.zero(b);
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.capacity);
            this.address = 0L;
        }
    }

    public long get(long p) {
        return Unsafe.getUnsafe().getLong(this.start + (p << 3));
    }

    public long scanSearch(long v, long low, long high) {
        for (long i = low; i < high; ++i) {
            long f = this.get(i);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1L);
        }
        return -(high + 1L);
    }

    public void set(long p, long v) {
        assert (p >= 0L && p <= this.limit - this.start >> 3);
        Unsafe.getUnsafe().putLong(this.start + (p << 3), v);
    }

    public void setPos(long p) {
        this.pos = this.start + p * 8L;
    }

    public long size() {
        return (int)((this.pos - this.start) / 8L);
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalBuilder();
        sb.put('{');
        int i = 0;
        while ((long)i < this.size()) {
            if (i > 0) {
                sb.put(',').put(' ');
            }
            sb.put(this.get(i));
            ++i;
        }
        sb.put('}');
        return ((Object)sb).toString();
    }

    public void zero(long v) {
        Vect.memset(this.start, this.pos - this.start, (int)v);
    }

    void ensureCapacity() {
        if (this.pos < this.limit) {
            return;
        }
        this.extend(this.capacity * 2L);
    }

    private void extend(long capacity) {
        long oldCapacity = this.capacity;
        this.capacity = capacity;
        long address = Unsafe.realloc(this.address, oldCapacity, capacity);
        this.pos = address + (this.pos - this.start);
        this.address = address;
        this.start = address;
        this.limit = address + capacity;
        LOG.debug().$("resized [old=").$(oldCapacity).$(", new=").$(this.capacity).$(']').$();
    }
}

