/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Os;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class FilesFacadeImpl
implements FilesFacade {
    public static final FilesFacade INSTANCE = new FilesFacadeImpl();
    private static final int _16M = 0x1000000;
    private long mapPageSize = 0L;

    @Override
    public long append(long fd, long buf, int len) {
        return Files.append(fd, buf, len);
    }

    @Override
    public boolean close(long fd) {
        return Files.close(fd) == 0;
    }

    @Override
    public int copy(LPSZ from, LPSZ to) {
        return Files.copy(from, to);
    }

    @Override
    public int errno() {
        return Os.errno();
    }

    @Override
    public boolean exists(LPSZ path) {
        return Files.exists(path);
    }

    @Override
    public boolean exists(long fd) {
        return Files.exists(fd);
    }

    @Override
    public void findClose(long findPtr) {
        Files.findClose(findPtr);
    }

    @Override
    public long findFirst(LPSZ path) {
        long ptr = Files.findFirst(path);
        if (ptr == -1L) {
            throw CairoException.instance(Os.errno()).put("findFirst failed on ").put(path);
        }
        return ptr;
    }

    @Override
    public long findName(long findPtr) {
        return Files.findName(findPtr);
    }

    @Override
    public int findNext(long findPtr) {
        int r = Files.findNext(findPtr);
        if (r == -1) {
            throw CairoException.instance(Os.errno()).put("findNext failed");
        }
        return r;
    }

    @Override
    public int findType(long findPtr) {
        return Files.findType(findPtr);
    }

    @Override
    public long getLastModified(LPSZ path) {
        return Files.getLastModified(path);
    }

    @Override
    public int msync(long addr, long len, boolean async) {
        return Files.msync(addr, len, async);
    }

    @Override
    public int fsync(long fd) {
        return Files.fsync(fd);
    }

    @Override
    public long getMapPageSize() {
        if (this.mapPageSize == 0L) {
            this.mapPageSize = this.computeMapPageSize();
        }
        return this.mapPageSize;
    }

    @Override
    public long getOpenFileCount() {
        return Files.getOpenFileCount();
    }

    @Override
    public long getPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public boolean isRestrictedFileSystem() {
        return Os.type == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateDir(LPSZ path, FindVisitor func) {
        long p = this.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    func.onFind(this.findName(p), this.findType(p));
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
            }
        }
    }

    @Override
    public long length(long fd) {
        return Files.length(fd);
    }

    @Override
    public long length(LPSZ name) {
        return Files.length(name);
    }

    @Override
    public int lock(long fd) {
        return Files.lock(fd);
    }

    @Override
    public int mkdir(LPSZ path, int mode) {
        return Files.mkdir(path, mode);
    }

    @Override
    public int mkdirs(LPSZ path, int mode) {
        return Files.mkdirs(path, mode);
    }

    @Override
    public long mmap(long fd, long len, long offset, int flags) {
        return Files.mmap(fd, len, offset, flags);
    }

    @Override
    public long mmap(long fd, long len, long flags, int mode, long baseAddress) {
        return Files.mmap(fd, len, flags, mode);
    }

    @Override
    public long mremap(long fd, long addr, long previousSize, long newSize, long offset, int mode) {
        return Files.mremap(fd, addr, previousSize, newSize, offset, mode);
    }

    @Override
    public void munmap(long address, long size) {
        Files.munmap(address, size);
    }

    @Override
    public long openAppend(LPSZ name) {
        return Files.openAppend(name);
    }

    @Override
    public long openRO(LPSZ name) {
        return Files.openRO(name);
    }

    @Override
    public long openRW(LPSZ name) {
        return Files.openRW(name);
    }

    @Override
    public long read(long fd, long buf, long len, long offset) {
        return Files.read(fd, buf, len, offset);
    }

    @Override
    public boolean remove(LPSZ name) {
        return Files.remove(name);
    }

    @Override
    public boolean rename(LPSZ from, LPSZ to) {
        return Files.rename(from, to);
    }

    @Override
    public int rmdir(Path name) {
        return Files.rmdir(name);
    }

    @Override
    public boolean touch(LPSZ path) {
        return Files.touch(path);
    }

    @Override
    public boolean truncate(long fd, long size) {
        return Files.truncate(fd, size);
    }

    @Override
    public boolean allocate(long fd, long size) {
        if (Os.type != 3) {
            return Files.allocate(fd, size);
        }
        return true;
    }

    @Override
    public long write(long fd, long address, long len, long offset) {
        return Files.write(fd, address, len, offset);
    }

    private long computeMapPageSize() {
        long pageSize = this.getPageSize();
        long mapPageSize = pageSize * pageSize;
        if (mapPageSize < pageSize || mapPageSize > 0x1000000L) {
            if (0x1000000L % pageSize == 0L) {
                return 0x1000000L;
            }
            return pageSize;
        }
        return mapPageSize;
    }
}

