/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;

public final class Hash {
    static final int HASH_BITS = Integer.MAX_VALUE;

    private Hash() {
    }

    public static int boundedHash(CharSequence s, int max) {
        return s == null ? -1 : Chars.hashCode(s) & 0xFFFFFFF & max;
    }

    public static int hashMem(long p, int len) {
        long hash = 0L;
        long hi = p + (long)len;
        while (hi - p > 7L) {
            hash = (hash << 5) - hash + Unsafe.getUnsafe().getLong(p);
            p += 8L;
        }
        while (p < hi) {
            hash = (hash << 5) - hash + (long)Unsafe.getUnsafe().getByte(p++);
        }
        return Hash.spread((int)hash);
    }

    public static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }
}

