/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class IntHashSet
extends AbstractIntHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final IntList list;

    public IntHashSet() {
        this(16);
    }

    public IntHashSet(IntHashSet that) {
        this(that.capacity, that.loadFactor, -1);
        this.addAll(that);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0.4, -1);
    }

    public IntHashSet(int initialCapacity, double loadFactor, int noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.list = new IntList(this.free);
        this.clear();
    }

    public boolean add(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public final void addAll(IntHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    public void addAt(int index, int key) {
        this.keys[index] = key;
        this.list.add(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.list.clear();
    }

    @Override
    public boolean excludes(int key) {
        return this.keyIndex(key) > -1;
    }

    @Override
    public int remove(int key) {
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            int key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    public boolean contains(int key) {
        return this.keyIndex(key) < 0;
    }

    public int get(int index) {
        return this.list.getQuick(index);
    }

    public int getLast() {
        return this.list.getLast();
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        this.keys = new int[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        int n = this.list.size();
        this.free -= n;
        for (int i = 0; i < n; ++i) {
            int key;
            this.keys[this.keyIndex((int)key)] = key = this.list.getQuick(i);
        }
    }
}

