/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class IntIntHashMap
extends AbstractIntHashSet {
    private static final int noEntryValue = -1;
    private int[] values;

    public IntIntHashMap() {
        this(8);
    }

    public IntIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private IntIntHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.values = new int[this.keys.length];
        this.clear();
    }

    public int get(int key) {
        return this.valueAt(this.keyIndex(key));
    }

    public void put(int key, int value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, int key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
        } else {
            this.keys[index] = key;
            this.values[index] = value;
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    public int valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : -1;
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        int[] oldValues = this.values;
        int[] oldKeys = this.keys;
        this.keys = new int[len];
        this.values = new int[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            int key = oldKeys[i];
            if (key == this.noEntryKeyValue) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

