/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Numbers;

public class IntLongAssociativeCache {
    public static final long NO_VALUE = -1L;
    public static final int UNUSED_KEY = 0;
    private static final int MIN_BLOCKS = 2;
    private static final int NOT_FOUND = -1;
    private static final int MINROWS = 16;
    private final int[] keys;
    private final long[] values;
    private final int rmask;
    private final int bmask;
    private final int blocks;
    private final int bshift;

    public IntLongAssociativeCache(int blocks, int rows) {
        this.blocks = Math.max(2, Numbers.ceilPow2(blocks));
        rows = Math.max(16, Numbers.ceilPow2(rows));
        int size = rows * this.blocks;
        if (size < 0) {
            throw new OutOfMemoryError();
        }
        this.keys = new int[size];
        this.values = new long[size];
        this.rmask = rows - 1;
        this.bmask = this.blocks - 1;
        this.bshift = Numbers.msb(this.blocks);
    }

    public long peek(int key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return -1L;
        }
        return this.values[index];
    }

    public long poll(int key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return -1L;
        }
        long value = this.values[index];
        this.keys[index] = 0;
        return value;
    }

    public int put(int key, long value) {
        int lo = this.lo(key);
        int ok = this.keys[lo + this.bmask];
        System.arraycopy(this.keys, lo, this.keys, lo + 1, this.bmask);
        System.arraycopy(this.values, lo, this.values, lo + 1, this.bmask);
        this.keys[lo] = key;
        this.values[lo] = value;
        return ok;
    }

    private int getIndex(int key) {
        int lo;
        int hi = lo + this.blocks;
        for (int i = lo = this.lo(key); i < hi; ++i) {
            int k = this.keys[i];
            if (k == 0) {
                return -1;
            }
            if (k != key) continue;
            return i;
        }
        return -1;
    }

    private int lo(int key) {
        return (key & this.rmask) << this.bshift;
    }
}

