/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256Sink;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;

public class Long256Impl
implements Long256Sink,
Long256,
Sinkable,
Long256Acceptor {
    public static final Long256Impl NULL_LONG256 = new Long256Impl();
    private long l0;
    private long l1;
    private long l2;
    private long l3;

    public static void putNull(long appendPointer) {
        Unsafe.getUnsafe().putLong(appendPointer, NULL_LONG256.getLong0());
        Unsafe.getUnsafe().putLong(appendPointer + 8L, NULL_LONG256.getLong1());
        Unsafe.getUnsafe().putLong(appendPointer + 16L, NULL_LONG256.getLong2());
        Unsafe.getUnsafe().putLong(appendPointer + 24L, NULL_LONG256.getLong3());
    }

    public void copyFrom(Long256 value) {
        this.l0 = value.getLong0();
        this.l1 = value.getLong1();
        this.l2 = value.getLong2();
        this.l3 = value.getLong3();
    }

    public boolean equals(Object obj) {
        Long256Impl that = (Long256Impl)obj;
        return this.l0 == that.l0 && this.l1 == that.l1 && this.l2 == that.l2 && this.l3 == that.l3;
    }

    @Override
    public long getLong0() {
        return this.l0;
    }

    @Override
    public void setLong0(long value) {
        this.l0 = value;
    }

    @Override
    public long getLong1() {
        return this.l1;
    }

    @Override
    public void setLong1(long value) {
        this.l1 = value;
    }

    @Override
    public long getLong2() {
        return this.l2;
    }

    @Override
    public void setLong2(long value) {
        this.l2 = value;
    }

    @Override
    public long getLong3() {
        return this.l3;
    }

    @Override
    public void setLong3(long value) {
        this.l3 = value;
    }

    @Override
    public void onDecoded(long l0, long l1, long l2, long l3) {
        this.l0 = l0;
        this.l1 = l1;
        this.l2 = l2;
        this.l3 = l3;
    }

    public void setAll(long l0, long l1, long l2, long l3) {
        this.l0 = l0;
        this.l1 = l1;
        this.l2 = l2;
        this.l3 = l3;
    }

    @Override
    public void toSink(CharSink sink) {
        Numbers.appendLong256(this.l0, this.l1, this.l2, this.l3, sink);
    }

    static {
        NULL_LONG256.setLong0(Long.MIN_VALUE);
        NULL_LONG256.setLong1(Long.MIN_VALUE);
        NULL_LONG256.setLong2(Long.MIN_VALUE);
        NULL_LONG256.setLong3(Long.MIN_VALUE);
    }
}

