/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.LongSort;
import io.questdb.std.LongVec;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Rnd;
import io.questdb.std.str.StringSink;
import java.util.Arrays;

public class LongList
implements Mutable,
LongVec {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final long DEFAULT_NO_ENTRY_VALUE = -1L;
    private final long noEntryValue;
    private long[] buffer;
    private int pos = 0;

    public LongList() {
        this(16);
    }

    public LongList(int capacity) {
        this(capacity, -1L);
    }

    public LongList(int capacity, long noEntryValue) {
        this.buffer = new long[capacity];
        this.noEntryValue = noEntryValue;
    }

    public LongList(LongList other) {
        this.buffer = new long[Math.max(other.size(), 16)];
        this.setPos(other.size());
        System.arraycopy(other.buffer, 0, this.buffer, 0, this.pos);
        this.noEntryValue = other.noEntryValue;
    }

    public void add(long value) {
        this.ensureCapacity(this.pos + 1);
        this.buffer[this.pos++] = value;
    }

    public void add(LongList that) {
        this.add(that, 0, that.size());
    }

    public void add(LongList that, int lo, int hi) {
        int p = this.pos;
        int s = hi - lo;
        this.ensureCapacity(p + s);
        System.arraycopy(that.buffer, lo, this.buffer, p, s);
        this.pos += s;
    }

    public void add(int index, long element) {
        this.ensureCapacity(++this.pos);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.pos - index - 1);
        this.buffer[index] = element;
    }

    public void arrayCopy(int srcPos, int dstPos, int length) {
        System.arraycopy(this.buffer, srcPos, this.buffer, dstPos, length);
    }

    public int binarySearch(long v) {
        int low = 0;
        int high = this.pos;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearch(v, low, high);
            }
            int mid = low + high - 1 >>> 1;
            long midVal = this.buffer[mid];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int binarySearchBlock(int low, int high, int shift, long v) {
        assert ((high - low) % (1 << shift) == 0);
        high >>= shift;
        low >>= shift;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearchBlock(v, low, high, shift);
            }
            int mid = (low + high - 1) / 2;
            long midVal = this.buffer[mid << shift];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            return mid << shift;
        }
        return -((low << shift) + 1);
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity. Integer overflow may be?");
        }
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            long[] buf = new long[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    public void erase() {
        this.pos = 0;
        Arrays.fill(this.buffer, this.noEntryValue);
    }

    public void extendAndSet(int index, long value) {
        this.ensureCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.buffer[index] = value;
    }

    public void fill(int from, int to, long value) {
        Arrays.fill(this.buffer, from, to, value);
    }

    public long get(int index) {
        if (index < this.pos) {
            return this.buffer[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public long getAndSetQuick(int index, long value) {
        long v = this.getQuick(index);
        this.buffer[index] = value;
        return v;
    }

    public long getLast() {
        if (this.pos > 0) {
            return this.buffer[this.pos - 1];
        }
        return this.noEntryValue;
    }

    public void setLast(long value) {
        if (this.pos > 0) {
            this.buffer[this.pos - 1] = value;
        }
    }

    @Override
    public long getQuick(int index) {
        assert (index < this.pos);
        return this.buffer[index];
    }

    @Override
    public void setQuick(int index, long value) {
        assert (index < this.pos);
        this.buffer[index] = value;
    }

    @Override
    public LongVec newInstance() {
        return new LongList(this.size());
    }

    public int hashCode() {
        long hashCode = 1L;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            long v = this.getQuick(i);
            hashCode = 31L * hashCode + (v == this.noEntryValue ? 0L : v);
        }
        return (int)hashCode;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof LongList && this.equals((LongList)that);
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalBuilder();
        sb.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sb.put(',');
            }
            sb.put(this.get(i));
        }
        sb.put(']');
        return ((Object)sb).toString();
    }

    public void increment(int index) {
        this.buffer[index] = this.buffer[index] + 1L;
    }

    public void insert(int index, int length) {
        this.ensureCapacity(this.pos + length);
        if (this.pos > index) {
            System.arraycopy(this.buffer, index, this.buffer, index + length, this.pos - index);
        }
        this.pos += length;
    }

    public void remove(long v) {
        int index = this.indexOf(v);
        if (index > -1) {
            this.removeIndex(index);
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        this.buffer[--this.pos] = this.noEntryValue;
    }

    public void removeIndexBlock(int index, int slotSize) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - slotSize;
        if (move > 0) {
            System.arraycopy(this.buffer, index + slotSize, this.buffer, index, move);
        }
        this.pos -= slotSize;
        Arrays.fill(this.buffer, this.pos, this.pos + slotSize, this.noEntryValue);
    }

    public void seed(int capacity, long value) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
        this.fill(0, capacity, value);
    }

    public void seed(int fromIndex, int count, long value) {
        int capacity = fromIndex + count;
        this.ensureCapacity(capacity);
        Arrays.fill(this.buffer, fromIndex, capacity, value);
    }

    public void set(int index, long element) {
        if (index < this.pos) {
            this.buffer[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, long value) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.buffer, value);
    }

    public final void setPos(int pos) {
        this.ensureCapacity(pos);
        this.pos = pos;
    }

    public void shuffle(Rnd rnd) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            this.swap(i, rnd.nextPositiveInt() & sz - 1);
        }
    }

    public int size() {
        return this.pos;
    }

    public void sort() {
        LongSort.sort(this, 0, this.size() - 1);
    }

    public LongList subset(int lo, int hi) {
        int _hi = Math.min(hi, this.pos);
        LongList that = new LongList(_hi - lo);
        System.arraycopy(this.buffer, lo, that.buffer, 0, _hi - lo);
        that.pos = _hi - lo;
        return that;
    }

    public void zero(int value) {
        Arrays.fill(this.buffer, 0, this.pos, (long)value);
    }

    private boolean equals(LongList that) {
        if (this.pos == that.pos) {
            int n = this.pos;
            for (int i = 0; i < n; ++i) {
                long lhs = this.getQuick(i);
                if (lhs == this.noEntryValue) {
                    return that.getQuick(i) == this.noEntryValue;
                }
                if (lhs != that.getQuick(i)) continue;
                return true;
            }
        }
        return false;
    }

    private int indexOf(long o) {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (o != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    private int scanSearch(long v, int low, int high) {
        for (int i = low; i < high; ++i) {
            long f = this.buffer[i];
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(high + 1);
    }

    private int scanSearchBlock(long v, int low, int high, int bitHint) {
        for (int i = low; i < high; ++i) {
            int index = i << bitHint;
            long f = this.buffer[index];
            if (f == v) {
                return index;
            }
            if (f <= v) continue;
            return -(index + 1);
        }
        return -((high << bitHint) + 1);
    }

    private void swap(int a, int b) {
        long tmp = this.getQuick(a);
        this.setQuick(a, this.getQuick(b));
        this.setQuick(b, tmp);
    }
}

