/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Numbers;

public class LongMatrix<T> {
    private final int bits;
    private int pos;
    private long[] data;
    private T[] payload;
    private int rows;

    public LongMatrix(int columnCount) {
        int cc = Numbers.ceilPow2(columnCount);
        this.pos = 0;
        this.rows = 512;
        this.data = new long[this.rows * cc];
        this.payload = new Object[this.rows];
        this.bits = Numbers.msb(cc);
    }

    public int addRow() {
        if (this.pos < this.rows) {
            return this.pos++;
        }
        return this.resize();
    }

    public int binarySearch(long v, int index) {
        int low = 0;
        int high = this.pos;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearch(v, index);
            }
            int mid = low + high - 1 >>> 1;
            long midVal = this.get(mid, index);
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void deleteRow(int r) {
        if (r < this.pos - 1) {
            int l = this.pos - r - 1;
            int next = r + 1;
            System.arraycopy(this.data, next << this.bits, this.data, r << this.bits, l << this.bits);
            System.arraycopy(this.payload, next, this.payload, r, l);
        }
        if (r < this.pos) {
            --this.pos;
        }
    }

    public long get(int r, int c) {
        return this.data[this.offset(r, c)];
    }

    public T get(int r) {
        return this.payload[r];
    }

    public void set(int r, T obj) {
        this.payload[r] = obj;
    }

    public void set(int r, int c, long value) {
        this.data[this.offset((int)r, (int)c)] = value;
    }

    public int size() {
        return this.pos;
    }

    public void zapTop(int count) {
        if (count < this.pos) {
            System.arraycopy(this.data, count << this.bits, this.data, 0, this.pos - count << this.bits);
            System.arraycopy(this.payload, count, this.payload, 0, this.pos - count);
            this.pos -= count;
        } else {
            this.pos = 0;
        }
    }

    private int offset(int r, int c) {
        return (r << this.bits) + c;
    }

    private int resize() {
        long[] _data = new long[this.rows << this.bits + 1];
        Object[] _payload = new Object[this.rows << 1];
        System.arraycopy(this.data, 0, _data, 0, this.rows << this.bits);
        System.arraycopy(this.payload, 0, _payload, 0, this.rows);
        this.data = _data;
        this.payload = _payload;
        this.rows <<= 1;
        return this.pos++;
    }

    private int scanSearch(long v, int index) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            long f = this.get(i, index);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(sz + 1);
    }
}

