/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.LongVec;

public class LongSort {
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int MAX_RUN_COUNT = 67;
    private static final int INSERTION_SORT_THRESHOLD = 47;

    public static void sort(LongVec vec, int left, int right) {
        LongVec a;
        LongVec b;
        if (right - left < 286) {
            LongSort.sort(vec, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (vec.getQuick(k) < vec.getQuick(k + 1)) {
                while (++k <= right && vec.getQuick(k - 1) <= vec.getQuick(k)) {
                }
            } else if (vec.getQuick(k) > vec.getQuick(k + 1)) {
                while (++k <= right && vec.getQuick(k - 1) >= vec.getQuick(k)) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    LongSort.swap(vec, lo, hi);
                }
            } else {
                int m = 33;
                while (++k <= right && vec.getQuick(k - 1) == vec.getQuick(k)) {
                    if (--m != 0) continue;
                    LongSort.sort(vec, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                LongSort.sort(vec, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = vec;
            a = vec.newInstance();
            int i = left - 1;
            while (++i < right) {
                a.setQuick(i, b.getQuick(i));
            }
        } else {
            a = vec;
            b = vec.newInstance();
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    if (q >= hi || p < mi && vec.getQuick(p) <= vec.getQuick(q)) {
                        b.setQuick(i, a.getQuick(p++));
                    } else {
                        b.setQuick(i, a.getQuick(q++));
                    }
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b.setQuick(i, a.getQuick(i));
                }
                run[++last] = right;
            }
            LongVec t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    private static void sort(LongVec vec, int left, int right, boolean leftmost) {
        long t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    long ai = vec.getQuick(i + 1);
                    while (ai < vec.getQuick(j)) {
                        LongSort.let(vec, j + 1, j);
                        if (j-- != left) continue;
                    }
                    vec.setQuick(j + 1, ai);
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (vec.getQuick(++left) >= vec.getQuick(left - 1));
                int k = left;
                while (++left <= right) {
                    long a2;
                    long a1 = vec.getQuick(k);
                    if (a1 < (a2 = vec.getQuick(left))) {
                        a2 = a1;
                        a1 = vec.getQuick(left);
                    }
                    while (a1 < vec.getQuick(--k)) {
                        LongSort.let(vec, k + 2, k);
                    }
                    vec.setQuick(++k + 1, a1);
                    while (a2 < vec.getQuick(--k)) {
                        LongSort.let(vec, k + 1, k);
                    }
                    vec.setQuick(k + 1, a2);
                    k = ++left;
                }
                long last = vec.getQuick(right);
                while (last < vec.getQuick(--right)) {
                    LongSort.let(vec, right + 1, right);
                }
                vec.setQuick(right + 1, last);
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (vec.getQuick(e2) < vec.getQuick(e1)) {
            LongSort.swap(vec, e2, e1);
        }
        if (vec.getQuick(e3) < vec.getQuick(e2)) {
            t = vec.getQuick(e3);
            LongSort.let(vec, e3, e2);
            vec.setQuick(e2, t);
            if (t < vec.getQuick(e1)) {
                LongSort.let(vec, e2, e1);
                vec.setQuick(e1, t);
            }
        }
        if (vec.getQuick(e4) < vec.getQuick(e3)) {
            t = vec.getQuick(e4);
            LongSort.let(vec, e4, e3);
            vec.setQuick(e3, t);
            if (t < vec.getQuick(e2)) {
                LongSort.let(vec, e3, e2);
                vec.setQuick(e2, t);
                if (t < vec.getQuick(e1)) {
                    LongSort.let(vec, e2, e1);
                    vec.setQuick(e1, t);
                }
            }
        }
        if (vec.getQuick(e5) < vec.getQuick(e4)) {
            t = vec.getQuick(e5);
            LongSort.let(vec, e5, e4);
            vec.setQuick(e4, t);
            if (t < vec.getQuick(e3)) {
                LongSort.let(vec, e4, e3);
                vec.setQuick(e3, t);
                if (t < vec.getQuick(e2)) {
                    LongSort.let(vec, e3, e2);
                    vec.setQuick(e2, t);
                    if (t < vec.getQuick(e1)) {
                        LongSort.let(vec, e2, e1);
                        vec.setQuick(e1, t);
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (vec.getQuick(e1) != vec.getQuick(e2) && vec.getQuick(e2) != vec.getQuick(e3) && vec.getQuick(e3) != vec.getQuick(e4) && vec.getQuick(e4) != vec.getQuick(e5)) {
            long ak;
            long pivot1 = vec.getQuick(e2);
            long pivot2 = vec.getQuick(e4);
            LongSort.let(vec, e2, left);
            LongSort.let(vec, e4, right);
            while (vec.getQuick(++less) < pivot1) {
            }
            while (vec.getQuick(--great) > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = vec.getQuick(k);
                if (ak < pivot1) {
                    LongSort.let(vec, k, less);
                    vec.setQuick(less, ak);
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (vec.getQuick(great) > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (vec.getQuick(great) < pivot1) {
                    LongSort.let(vec, k, less);
                    LongSort.let(vec, less, great);
                    ++less;
                } else {
                    LongSort.let(vec, k, great);
                }
                vec.setQuick(great, ak);
                --great;
            }
            LongSort.let(vec, left, less - 1);
            vec.setQuick(less - 1, pivot1);
            LongSort.let(vec, right, great + 1);
            vec.setQuick(great + 1, pivot2);
            LongSort.sort(vec, left, less - 2, leftmost);
            LongSort.sort(vec, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (vec.getQuick(less) == pivot1) {
                    ++less;
                }
                while (vec.getQuick(great) == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = vec.getQuick(k);
                    if (ak == pivot1) {
                        LongSort.let(vec, k, less);
                        vec.setQuick(less, ak);
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (vec.getQuick(great) == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (vec.getQuick(great) == pivot1) {
                        LongSort.let(vec, k, less);
                        vec.setQuick(less, pivot1);
                        ++less;
                    } else {
                        LongSort.let(vec, k, great);
                    }
                    vec.setQuick(great, ak);
                    --great;
                }
            }
            LongSort.sort(vec, less, great, false);
        } else {
            long pivot = vec.getQuick(e3);
            for (int k = less; k <= great; ++k) {
                if (vec.getQuick(k) == pivot) continue;
                long ak = vec.getQuick(k);
                if (ak < pivot) {
                    LongSort.let(vec, k, less);
                    vec.setQuick(less, ak);
                    ++less;
                    continue;
                }
                while (vec.getQuick(great) > pivot) {
                    --great;
                }
                if (vec.getQuick(great) < pivot) {
                    LongSort.let(vec, k, less);
                    LongSort.let(vec, less, great);
                    ++less;
                } else {
                    vec.setQuick(k, pivot);
                }
                vec.setQuick(great, ak);
                --great;
            }
            LongSort.sort(vec, left, less - 1, leftmost);
            LongSort.sort(vec, great + 1, right, false);
        }
    }

    private static void swap(LongVec vec, int a, int b) {
        long tmp = vec.getQuick(a);
        vec.setQuick(a, vec.getQuick(b));
        vec.setQuick(b, tmp);
    }

    private static void let(LongVec vec, int a, int b) {
        vec.setQuick(a, vec.getQuick(b));
    }
}

