/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseCharSequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.Arrays;

public class LowerCaseCharSequenceIntHashMap
extends AbstractLowerCaseCharSequenceHashSet {
    private static final int NO_ENTRY_VALUE = -1;
    private final int noEntryValue;
    protected int[] values;
    private final ObjList<CharSequence> list;

    public LowerCaseCharSequenceIntHashMap() {
        this(8);
    }

    public LowerCaseCharSequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public LowerCaseCharSequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.list = new ObjList(this.capacity);
        this.values = new int[this.keys.length];
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            CharSequence key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public int valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : this.noEntryValue;
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public int get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public boolean put(CharSequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, key, value);
        this.list.add(key);
        return true;
    }

    public void putIfAbsent(CharSequence key, int value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, key, value);
        }
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    protected void putAt0(int index, CharSequence key, int value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        int[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[len];
        this.values = new int[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }
}

