/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseCharSequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.Arrays;

public class LowerCaseCharSequenceObjHashMap<T>
extends AbstractLowerCaseCharSequenceHashSet {
    private final ObjList<CharSequence> list;
    private T[] values;

    public LowerCaseCharSequenceObjHashMap() {
        this(8);
    }

    public LowerCaseCharSequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    public LowerCaseCharSequenceObjHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.values = new Object[this.keys.length];
        this.list = new ObjList(this.capacity);
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, null);
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = null;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            CharSequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public T get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    public boolean put(CharSequence key, T value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, T value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, key, value);
        this.list.add(key);
        return true;
    }

    public void putIfAbsent(CharSequence key, T value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, key, value);
        }
    }

    public T valueAt(int index) {
        return index < 0 ? (T)this.valueAtQuick(index) : null;
    }

    public T valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    private void putAt0(int index, CharSequence key, T value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int arrayCapacity = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        T[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[arrayCapacity];
        this.values = new Object[arrayCapacity];
        Arrays.fill(this.keys, null);
        this.mask = arrayCapacity - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    public void putAll(LowerCaseCharSequenceObjHashMap<T> other) {
        CharSequence[] otherKeys = other.keys;
        T[] otherValues = other.values;
        int n = otherKeys.length;
        for (int i = 0; i < n; ++i) {
            if (otherKeys[i] == noEntryKey) continue;
            this.put(otherKeys[i], otherValues[i]);
        }
    }
}

