/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.ImmutableIterator;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjIntHashMap<K>
implements Iterable<Entry<K>>,
Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final int noKeyValue;
    private final double loadFactor;
    private final EntryIterator iterator = new EntryIterator();
    private K[] keys;
    private int[] values;
    private int free;
    private int capacity;
    private int mask;

    public ObjIntHashMap() {
        this(8);
    }

    private ObjIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.3, -1);
    }

    public ObjIntHashMap(int initialCapacity, double loadFactor, int noKeyValue) {
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        this.capacity = Math.max(initialCapacity, 16);
        this.loadFactor = loadFactor;
        this.noKeyValue = noKeyValue;
        this.keys = this.getKeys();
        this.values = new int[this.keys.length];
        this.mask = this.keys.length - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, noEntryValue);
    }

    public void clear(int newCapacity) {
        if (newCapacity <= this.capacity) {
            this.clear();
        } else {
            this.free = this.capacity = Numbers.ceilPow2(newCapacity);
            this.keys = this.getKeys();
            this.values = new int[this.keys.length];
            this.mask = this.keys.length - 1;
            Arrays.fill(this.keys, noEntryValue);
        }
    }

    private K[] getKeys() {
        return new Object[Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor))];
    }

    public int get(K key) {
        return this.valueAt(this.keyIndex(key));
    }

    @Override
    @NotNull
    public Iterator<Entry<K>> iterator() {
        this.iterator.index = 0;
        return this.iterator;
    }

    public int keyIndex(K key) {
        int index = Hash.spread(key.hashCode()) & this.mask;
        K kv = this.keys[index];
        if (kv == noEntryValue) {
            return index;
        }
        if (kv == key || key.equals(kv)) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public void put(K key, int value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, K key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return;
        }
        this.putAt0(index, key, value);
    }

    public boolean putIfAbsent(K key, int value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt(index, key, value);
            return true;
        }
        return false;
    }

    public int size() {
        return this.capacity - this.free;
    }

    public int valueAt(int index) {
        int index1 = -index - 1;
        return index < 0 ? this.values[index1] : this.noKeyValue;
    }

    private int probe(K key, int index) {
        K kv;
        do {
            if ((kv = this.keys[index = index + 1 & this.mask]) != noEntryValue) continue;
            return index;
        } while (kv != key && !key.equals(kv));
        return -index - 1;
    }

    private void putAt0(int index, K key, int value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        this.free = this.capacity *= 2;
        int[] oldValues = this.values;
        K[] oldKeys = this.keys;
        this.keys = new Object[Numbers.ceilPow2(Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor)))];
        this.values = new int[this.keys.length];
        Arrays.fill(this.keys, noEntryValue);
        this.mask = this.keys.length - 1;
        int i = oldKeys.length;
        while (i-- > 0) {
            if (oldKeys[i] == noEntryValue) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public class EntryIterator
    implements ImmutableIterator<Entry<K>> {
        private final Entry<K> entry = new Entry();
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ObjIntHashMap.this.values.length && (ObjIntHashMap.this.keys[this.index] != noEntryValue || this.scan());
        }

        @Override
        public Entry<K> next() {
            this.entry.key = ObjIntHashMap.this.keys[this.index];
            int index1 = this.index++;
            this.entry.value = ObjIntHashMap.this.values[index1];
            return this.entry;
        }

        private boolean scan() {
            do {
                ++this.index;
            } while (this.index < ObjIntHashMap.this.values.length && ObjIntHashMap.this.keys[this.index] == noEntryValue);
            return this.index < ObjIntHashMap.this.values.length;
        }
    }

    public static class Entry<V> {
        public V key;
        public int value;
    }
}

