/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.ex.FatalError;
import io.questdb.std.ex.KerberosException;
import io.questdb.std.str.CharSequenceZ;
import io.questdb.std.str.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class Os {
    public static final int WINDOWS = 3;
    public static final int _32Bit = -2;
    public static final int type;
    public static final int OSX_AMD64 = 1;
    public static final int LINUX_AMD64 = 2;
    public static final int LINUX_ARM64 = 4;
    public static final int FREEBSD = 5;
    public static final int OSX_ARM64 = 6;

    private Os() {
    }

    public static native long currentTimeMicros();

    public static native long currentTimeNanos();

    public static native int errno();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long forkExec(CharSequence args) {
        ObjList<Path> paths = Chars.splitLpsz(args);
        int n = paths.size();
        try {
            long l;
            long argv = Unsafe.malloc((long)(n + 1) * 8L);
            try {
                long p = argv;
                for (int i = 0; i < n; ++i) {
                    Unsafe.getUnsafe().putLong(p, paths.getQuick(i).address());
                    p += 8L;
                }
                Unsafe.getUnsafe().putLong(p, 0L);
                l = Os.forkExec(argv);
            }
            catch (Throwable throwable) {
                Unsafe.free(argv, n + 1);
                throw throwable;
            }
            Unsafe.free(argv, n + 1);
            return l;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                paths.getQuick(i).close();
            }
        }
    }

    public static native long compareAndSwap(long var0, long var2, long var4);

    public static int forkExecPid(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT + 8L);
    }

    public static int forkExecReadFd(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT);
    }

    public static int forkExecWriteFd(long forkExecT) {
        return Unsafe.getUnsafe().getInt(forkExecT + 4L);
    }

    public static byte[] generateKerberosToken(CharSequence spn) throws KerberosException {
        try (CharSequenceZ cs = new CharSequenceZ(spn);){
            long struct = Os.generateKrbToken(cs.address());
            int status = Unsafe.getUnsafe().getInt(struct);
            int bufLen = Unsafe.getUnsafe().getInt(struct + 4L);
            long ptoken = Unsafe.getUnsafe().getLong(struct + 8L);
            if (status != 0) {
                Os.freeKrbToken(struct);
                throw new KerberosException(status);
            }
            byte[] token = new byte[bufLen];
            for (int i = 0; i < bufLen; ++i) {
                token[i] = Unsafe.getUnsafe().getByte(ptoken + (long)i);
            }
            Os.freeKrbToken(struct);
            byte[] byArray = token;
            return byArray;
        }
    }

    public static native int getPid();

    public static void init() {
    }

    public static int setCurrentThreadAffinity(int cpu) {
        if (cpu == -1) {
            return 0;
        }
        return Os.setCurrentThreadAffinity0(cpu);
    }

    private static native int setCurrentThreadAffinity0(int var0);

    private static native long generateKrbToken(long var0);

    private static native void freeKrbToken(long var0);

    private static native long forkExec(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLib(String lib) {
        InputStream is = Os.class.getResourceAsStream(lib);
        if (is == null) {
            throw new FatalError("Internal error: cannot find " + lib + ", broken package?");
        }
        try {
            File tempLib = null;
            try {
                int dot = lib.indexOf(46);
                tempLib = File.createTempFile(lib.substring(0, dot), lib.substring(dot));
                try (FileOutputStream out = new FileOutputStream(tempLib);){
                    int read;
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                }
                finally {
                    tempLib.deleteOnExit();
                }
                System.load(tempLib.getAbsolutePath());
            }
            catch (IOException e) {
                throw new FatalError("Internal error: cannot unpack " + tempLib, e);
            }
        }
        finally {
            Misc.free(is);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            String osName = System.getProperty("os.name");
            if (osName.contains("Linux")) {
                if ("aarch64".equals(System.getProperty("os.arch"))) {
                    type = 4;
                    Os.loadLib("/io/questdb/bin/armlinux/libquestdb.so");
                    return;
                } else {
                    type = 2;
                    Os.loadLib("/io/questdb/bin/linux/libquestdb.so");
                }
                return;
            } else if (osName.contains("Mac")) {
                if ("aarch64".equals(System.getProperty("os.arch"))) {
                    type = 6;
                    Os.loadLib("/io/questdb/bin/armosx/libquestdb.dylib");
                    return;
                } else {
                    type = 1;
                    Os.loadLib("/io/questdb/bin/osx/libquestdb.dylib");
                }
                return;
            } else if (osName.contains("Windows")) {
                type = 3;
                Os.loadLib("/io/questdb/bin/windows/libquestdb.dll");
                return;
            } else {
                if (!osName.contains("FreeBSD")) throw new Error("Unsupported OS: " + osName);
                type = 5;
                Os.loadLib("/io/questdb/bin/freebsd/libquestdb.so");
            }
            return;
        } else {
            type = -2;
        }
    }
}

