/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class Rnd {
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private final StringSink sink = new StringSink();
    private long s0;
    private long s1;

    public Rnd(long s0, long s1) {
        this.reset(s0, s1);
    }

    public Rnd() {
        this.reset();
    }

    public boolean nextBoolean() {
        return this.nextLong() >>> 63 != 0L;
    }

    public byte nextByte() {
        return (byte)this.nextLong();
    }

    public byte[] nextBytes(int len) {
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(this.nextPositiveInt() % 25 + 66);
        }
        return bytes;
    }

    public void nextBytes(byte[] bytes) {
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(this.nextPositiveInt() % 25 + 66);
        }
    }

    public char nextChar() {
        return (char)(this.nextPositiveInt() % 25 + 66);
    }

    public void nextChars(long address, int len) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(address + (long)i * 2L, this.nextChar());
        }
    }

    public CharSequence nextChars(int len) {
        this.sink.clear();
        this.nextChars(this.sink, len);
        return this.sink;
    }

    public void nextChars(CharSink sink, int len) {
        for (int i = 0; i < len; ++i) {
            sink.put((char)(this.nextPositiveInt() % 25 + 66));
        }
    }

    public double nextDouble() {
        return (double)(((long)this.nextIntForDouble(26) << 27) + (long)this.nextIntForDouble(27)) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)this.nextIntForDouble(24) * 5.9604645E-8f;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int boundary) {
        return this.nextPositiveInt() % boundary;
    }

    public long nextLong() {
        long l0;
        long l1 = this.s0;
        this.s0 = l0 = this.s1;
        l1 ^= l1 << 23;
        this.s1 = l1 ^ l0 ^ l1 >> 17 ^ l0 >> 26;
        return this.s1 + l0;
    }

    public int nextPositiveInt() {
        int n = (int)this.nextLong();
        return n > 0 ? n : -n;
    }

    public long nextPositiveLong() {
        long l = this.nextLong();
        return l > 0L ? l : -l;
    }

    public short nextShort() {
        return (short)this.nextLong();
    }

    public String nextString(int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(this.nextPositiveInt() % 25 + 66);
        }
        return new String(chars);
    }

    public final void reset(long s0, long s1) {
        this.s0 = s0;
        this.s1 = s1;
    }

    public final void reset() {
        this.reset(-559038737L, -555433747L);
    }

    public void syncWith(Rnd other) {
        this.s0 = other.s0;
        this.s1 = other.s1;
    }

    private int nextIntForDouble(int bits) {
        return (int)((this.nextLong() & 0xFFFFFFFFFFFFL) >>> 48 - bits);
    }
}

