/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.ColumnTypes;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;

public final class Rosti {
    public static final int FAKE_ALLOC_SIZE = 1024;

    public static native long alloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alloc(ColumnTypes types, long capacity) {
        int columnCount = types.getColumnCount();
        long mem = Unsafe.malloc(4L * (long)columnCount);
        try {
            long p = mem;
            for (int i = 0; i < columnCount; ++i) {
                Unsafe.getUnsafe().putInt(p, types.getColumnType(i));
                p += 4L;
            }
            Unsafe.recordMemAlloc(1024L);
            long l = Rosti.alloc(mem, columnCount, Numbers.ceilPow2(capacity) - 1L);
            return l;
        }
        finally {
            Unsafe.free(mem, 4L * (long)columnCount);
        }
    }

    public static void free(long pRosti) {
        Rosti.free0(pRosti);
        Unsafe.recordMemAlloc(-1024L);
    }

    private static native void free0(long var0);

    public static native void clear(long var0);

    public static native void keyedIntDistinct(long var0, long var2, long var4);

    public static native void keyedHourDistinct(long var0, long var2, long var4);

    public static native void keyedHourCount(long var0, long var2, long var4, int var6);

    public static native void keyedIntCount(long var0, long var2, long var4, int var6);

    public static native void keyedIntCountMerge(long var0, long var2, int var4);

    public static native void keyedIntSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntSumDoubleMerge(long var0, long var2, int var4);

    public static native void keyedIntSumDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native void keyedIntAvgDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native void keyedIntKSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourKSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntKSumDoubleMerge(long var0, long var2, int var4);

    public static native void keyedIntKSumDoubleWrapUp(long var0, int var2, double var3, long var5);

    public static native void keyedIntNSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourNSumDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntNSumDoubleMerge(long var0, long var2, int var4);

    public static native void keyedIntNSumDoubleWrapUp(long var0, int var2, double var3, long var5, double var7);

    public static native void keyedIntMinDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMinDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMinDoubleMerge(long var0, long var2, int var4);

    public static native void keyedIntMinDoubleWrapUp(long var0, int var2, double var3);

    public static native void keyedIntMaxDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMaxDouble(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMaxDoubleMerge(long var0, long var2, int var4);

    public static native void keyedIntMaxDoubleWrapUp(long var0, int var2, double var3);

    public static native void keyedIntSumInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourSumInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntSumIntMerge(long var0, long var2, int var4);

    public static native void keyedIntMinInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMinInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMinIntMerge(long var0, long var2, int var4);

    public static native void keyedIntMinIntWrapUp(long var0, int var2, int var3);

    public static native void keyedIntMaxInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMaxInt(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMaxIntMerge(long var0, long var2, int var4);

    public static native void keyedIntMaxIntWrapUp(long var0, int var2, int var3);

    public static native void keyedIntSumLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourSumLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntSumLongMerge(long var0, long var2, int var4);

    public static native void keyedIntSumLongWrapUp(long var0, int var2, long var3, long var5);

    public static native void keyedIntAvgLongWrapUp(long var0, int var2, double var3, long var5);

    public static native void keyedIntMinLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMinLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMinLongMerge(long var0, long var2, int var4);

    public static native void keyedIntMinLongWrapUp(long var0, int var2, long var3);

    public static native void keyedIntMaxLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedHourMaxLong(long var0, long var2, long var4, long var6, int var8);

    public static native void keyedIntMaxLongMerge(long var0, long var2, int var4);

    public static native void keyedIntMaxLongWrapUp(long var0, int var2, long var3);

    public static long getCtrl(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti);
    }

    public static long getSlots(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 8L);
    }

    public static long getSize(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 16L);
    }

    public static long getSlotShift(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 40L);
    }

    public static long getValueOffsets(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 56L);
    }

    public static long getInitialValuesSlot(long pRosti) {
        return Unsafe.getUnsafe().getLong(pRosti + 64L);
    }

    public static void printRosti(long pRosti) {
        long ctrl;
        long slots = Rosti.getSlots(pRosti);
        long shift = Rosti.getSlotShift(pRosti);
        long start = ctrl = Rosti.getCtrl(pRosti);
        long count = Rosti.getSize(pRosti);
        while (count > 0L) {
            byte b = Unsafe.getUnsafe().getByte(ctrl);
            if ((b & 0x80) == 0) {
                long p = slots + (ctrl - start << (int)shift);
                System.out.println(Unsafe.getUnsafe().getInt(p) + " -> " + Unsafe.getUnsafe().getDouble(p + 12L));
                --count;
            }
            ++ctrl;
        }
    }

    public static long getInitialValueSlot(long pRosti, int columnIndex) {
        return Rosti.getInitialValuesSlot(pRosti) + (long)Unsafe.getUnsafe().getInt(Rosti.getValueOffsets(pRosti) + (long)columnIndex * 4L);
    }
}

