/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Unsafe;

public final class Vect {
    public static native double avgDouble(long var0, long var2);

    public static native double avgInt(long var0, long var2);

    public static native double avgLong(long var0, long var2);

    public static native long binarySearch64Bit(long var0, long var2, long var4, long var6, int var8);

    public static native long binarySearchIndexT(long var0, long var2, long var4, long var6, int var8);

    public static long boundedBinarySearch64Bit(long pData, long value, long low, long high, int scanDirection) {
        long index = Vect.binarySearch64Bit(pData, value, low, high, scanDirection);
        if (index < 0L) {
            return -index - 1L - 1L;
        }
        return index;
    }

    public static long boundedBinarySearchIndexT(long pData, long value, long low, long high, int scanDirection) {
        long index = Vect.binarySearchIndexT(pData, value, low, high, scanDirection);
        if (index < 0L) {
            return -index - 1L - 1L;
        }
        return index;
    }

    public static native void copyFromTimestampIndex(long var0, long var2, long var4, long var6);

    public static native void flattenIndex(long var0, long var2);

    public static native void freeMergedIndex(long var0);

    public static native long getPerformanceCounter(int var0);

    public static native int getPerformanceCountersCount();

    public static native int getSupportedInstructionSet();

    public static String getSupportedInstructionSetName() {
        int inst = Vect.getSupportedInstructionSet();
        String base = inst >= 10 ? "AVX512" : (inst >= 8 ? "AVX2" : (inst >= 5 ? "SSE4.1" : (inst >= 2 ? "SSE2" : "Vanilla")));
        return " [" + base + "," + Vect.getSupportedInstructionSet() + "]";
    }

    public static native boolean hasNull(long var0, long var2);

    public static native void indexReshuffle16Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle256Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle32Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle64Bit(long var0, long var2, long var4, long var6);

    public static native void indexReshuffle8Bit(long var0, long var2, long var4, long var6);

    public static native long makeTimestampIndex(long var0, long var2, long var4, long var6);

    public static native double maxDouble(long var0, long var2);

    public static native int maxInt(long var0, long var2);

    public static native long maxLong(long var0, long var2);

    public static void memcpy(long src, long dst, long len) {
        if (len < 4096L) {
            Unsafe.getUnsafe().copyMemory(src, dst, len);
        } else {
            Vect.memcpy0(src, dst, len);
        }
    }

    public static native void memmove(long var0, long var2, long var4);

    public static native void memset(long var0, long var2, int var4);

    public static native long mergeLongIndexesAsc(long var0, int var2);

    public static native void mergeShuffle16Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle256Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle32Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle64Bit(long var0, long var2, long var4, long var6, long var8);

    public static native void mergeShuffle8Bit(long var0, long var2, long var4, long var6, long var8);

    public static native long mergeTwoLongIndexesAsc(long var0, long var2, long var4, long var6);

    public static native double minDouble(long var0, long var2);

    public static native int minInt(long var0, long var2);

    public static native long minLong(long var0, long var2);

    public static native void oooCopyIndex(long var0, long var2, long var4);

    public static native void oooMergeCopyBinColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void oooMergeCopyStrColumn(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static native void quickSortLongIndexAscInPlace(long var0, long var2);

    public static native void radixSortLongIndexAscInPlace(long var0, long var2, long var4);

    public static native void resetPerformanceCounters();

    public static native void setMemoryDouble(long var0, double var2, long var4);

    public static native void setMemoryFloat(long var0, float var2, long var3);

    public static native void setMemoryInt(long var0, int var2, long var3);

    public static native void setMemoryLong(long var0, long var2, long var4);

    public static native void setMemoryShort(long var0, short var2, long var3);

    public static native void setVarColumnRefs32Bit(long var0, long var2, long var4);

    public static native void setVarColumnRefs64Bit(long var0, long var2, long var4);

    public static native void shiftCopyFixedSizeColumnData(long var0, long var2, long var4, long var6, long var8);

    public static native long shiftTimestampIndex(long var0, long var2, long var4);

    public static native void sortLongIndexAscInPlace(long var0, long var2);

    public static native void sortULongAscInPlace(long var0, long var2);

    public static native long sortVarColumn(long var0, long var2, long var4, long var6, long var8, long var10);

    public static native double sumDouble(long var0, long var2);

    public static native double sumDoubleKahan(long var0, long var2);

    public static native double sumDoubleNeumaier(long var0, long var2);

    public static native long sumInt(long var0, long var2);

    public static native long sumLong(long var0, long var2);

    private static native void memcpy0(long var0, long var2, long var4);
}

