/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AutoClosableObjectFactory;
import io.questdb.std.CleanClosable;
import io.questdb.std.Misc;
import java.io.Closeable;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class WeakAutoClosableObjectPool<T extends CleanClosable>
implements Closeable {
    private final ArrayDeque<T> cache = new ArrayDeque();
    private final AutoClosableObjectFactory<T> factory;
    private final int size;

    public WeakAutoClosableObjectPool(@NotNull AutoClosableObjectFactory<T> factory, int size) {
        this.factory = factory;
        this.size = size;
        this.fill();
    }

    @Override
    public void close() {
        while (this.cache.size() > 0) {
            Misc.free(this.cache.pop());
        }
    }

    public T pop() {
        CleanClosable obj = (CleanClosable)this.cache.poll();
        return (T)(obj == null ? this.factory.newInstance(this) : obj);
    }

    public void push(T obj) {
        assert (obj != null);
        this.cache.push(obj);
    }

    private void fill() {
        for (int i = 0; i < this.size; ++i) {
            this.cache.add(this.factory.newInstance(this));
        }
    }
}

